/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.error.code.internal.servlet.taglib;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;

public abstract class BasePortalErrorCodeDynamicInclude
implements DynamicInclude {
    private static final String _CHARSET = "; charset=UTF-8";
    private static final Log _log = LogFactoryUtil.getLog(BasePortalErrorCodeDynamicInclude.class);
    private String _contentType;
    private String _key;

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        httpServletResponse.setContentType(this._contentType);
        String message = (String)httpServletRequest.getAttribute("javax.servlet.error.message");
        PrintWriter printWriter = httpServletResponse.getWriter();
        int statusCode = (Integer)httpServletRequest.getAttribute("javax.servlet.error.status_code");
        if (_log.isDebugEnabled()) {
            String requestURI = (String)httpServletRequest.getAttribute("javax.servlet.error.request_uri");
            Throwable throwable = (Throwable)httpServletRequest.getAttribute("javax.servlet.error.exception");
            this.write(message, printWriter, requestURI, statusCode, throwable);
        } else {
            this.write(message, printWriter, statusCode);
        }
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register(this._key);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        String mimeType = MapUtil.getString(properties, (String)"mime.type", null);
        if (mimeType == null) {
            throw new IllegalArgumentException("Mime type is null");
        }
        this._contentType = mimeType.concat(_CHARSET);
        this._key = "/errors/code.jsp#".concat(mimeType);
    }

    protected abstract void write(String var1, PrintWriter var2, int var3);

    protected abstract void write(String var1, PrintWriter var2, String var3, int var4, Throwable var5);
}

