/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.error.code.internal.servlet.taglib;

import com.liferay.portal.error.code.internal.servlet.taglib.BasePortalErrorCodeDynamicInclude;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReader;
import java.io.PrintWriter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"mime.type=application/xml"}, service={DynamicInclude.class})
public class ApplicationXMLPortalErrorCodeDynamicInclude
extends BasePortalErrorCodeDynamicInclude {
    @Reference
    private SAXReader _saxReader;

    @Override
    protected void write(String message, PrintWriter printWriter, int statusCode) {
        Document document = this._saxReader.createDocument("UTF-8");
        Element errorElement = document.addElement("error");
        Element messageElement = errorElement.addElement("message");
        messageElement.addText(message);
        Element statusCodeElement = errorElement.addElement("status-code");
        statusCodeElement.addText(String.valueOf(statusCode));
        printWriter.print(document.asXML());
    }

    @Override
    protected void write(String message, PrintWriter printWriter, String requestURI, int statusCode, Throwable throwable) {
        Document document = this._saxReader.createDocument("UTF-8");
        Element errorElement = document.addElement("error");
        Element messageElement = errorElement.addElement("message");
        messageElement.addText(message);
        Element requestURIElement = errorElement.addElement("request-uri");
        requestURIElement.addText(requestURI);
        Element statusCodeElement = errorElement.addElement("status-code");
        statusCodeElement.addText(String.valueOf(statusCode));
        if (throwable != null) {
            Element throwableElement = errorElement.addElement("throwable");
            throwableElement.addCDATA(StackTraceUtil.getStackTrace((Throwable)throwable));
        }
        printWriter.print(document.asXML());
    }
}

