/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.plugin.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Dictionary;
import java.util.Objects;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationPlugin;

public class WebIdToCompanyConfigurationPluginImpl
implements ConfigurationPlugin {
    private static final Log _log = LogFactoryUtil.getLog(WebIdToCompanyConfigurationPluginImpl.class);
    private final BundleContext _bundleContext;
    private final DB _db = DBManagerUtil.getDB();

    public WebIdToCompanyConfigurationPluginImpl(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    public void modifyConfiguration(ServiceReference<?> serviceReference, Dictionary<String, Object> properties) {
        block45: {
            String webId = (String)properties.get("dxp.lxc.liferay.com.virtualInstanceId");
            if (Validator.isNull((String)webId)) {
                return;
            }
            if (Objects.equals(webId, "default")) {
                webId = PropsValues.COMPANY_DEFAULT_WEB_ID;
            }
            try {
                ServiceReference dataSourceServiceReference = this._bundleContext.getServiceReference(DataSource.class);
                if (dataSourceServiceReference == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)"Data source service is null");
                    }
                    return;
                }
                DataSource dataSource = (DataSource)this._bundleContext.getService(dataSourceServiceReference);
                try (Connection connection = dataSource.getConnection();
                     PreparedStatement preparedStatement = connection.prepareStatement(this._db.buildSQL("select companyId from Company where webId = ?"));){
                    preparedStatement.setString(1, webId);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        if (resultSet.next()) {
                            long companyId = resultSet.getLong(1);
                            properties.put("companyId", companyId);
                            if (_log.isInfoEnabled()) {
                                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Injected company ID ", companyId, " for web ID ", webId}));
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                if (!_log.isWarnEnabled()) break block45;
                _log.warn((Object)("Skip web ID " + webId));
            }
        }
    }
}

