/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.component.blacklist.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.component.blacklist.ComponentBlacklist;
import com.liferay.portal.component.blacklist.internal.ComponentBlacklistConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;

@Component(configurationPid={"com.liferay.portal.component.blacklist.internal.ComponentBlacklistConfiguration"}, immediate=true, service={ComponentBlacklist.class})
public class ComponentBlacklistImpl
implements ComponentBlacklist {
    @Reference
    protected ServiceComponentRuntime serviceComponentRuntime;
    private static final Log _log = LogFactoryUtil.getLog(ComponentBlacklistImpl.class);
    private Set<String> _blacklistComponentNames;
    private BundleContext _bundleContext;
    private BundleListener _bundleListener;
    private final Set<String> _disabledComponentNames = new HashSet<String>();

    public boolean contains(String componentName) {
        return this._blacklistComponentNames.contains(componentName);
    }

    public Set<String> getBlacklistComponentNames() {
        return Collections.unmodifiableSet(this._blacklistComponentNames);
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
        this._bundleListener = new ComponentDisablingBundleListener();
        this._bundleContext.addBundleListener(this._bundleListener);
        this.modified(properties);
    }

    @Deactivate
    protected void deactivate() {
        this._bundleContext.removeBundleListener(this._bundleListener);
        this.modified(Collections.emptyMap());
        this._bundleContext = null;
        this._disabledComponentNames.clear();
    }

    protected void disableComponents(Bundle bundle, Set<String> blacklistComponentNames) {
        this._performComponentDescriptionDTOOperation(bundle, blacklistComponentNames, componentDescriptionDTO -> {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Disabling ", componentDescriptionDTO.name, " from bundle ", bundle.getSymbolicName()}));
            }
            this.serviceComponentRuntime.disableComponent(componentDescriptionDTO);
            this._disabledComponentNames.add(componentDescriptionDTO.name);
        });
    }

    protected void enableComponents(Bundle bundle, Set<String> reactivateComponentNames) {
        this._performComponentDescriptionDTOOperation(bundle, reactivateComponentNames, componentDescriptionDTO -> {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Enabling ", componentDescriptionDTO.name, " from bundle ", bundle.getSymbolicName()}));
            }
            this.serviceComponentRuntime.enableComponent(componentDescriptionDTO);
            this._disabledComponentNames.remove(componentDescriptionDTO.name);
        });
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        Bundle[] bundles = this._bundleContext.getBundles();
        ComponentBlacklistConfiguration componentBlacklistConfiguration = (ComponentBlacklistConfiguration)ConfigurableUtil.createConfigurable(ComponentBlacklistConfiguration.class, properties);
        this._blacklistComponentNames = new HashSet<String>(Arrays.asList(componentBlacklistConfiguration.blacklistComponentNames()));
        HashSet<String> reactivateComponentNames = new HashSet<String>();
        this._disabledComponentNames.forEach(disabledComponentName -> {
            if (!this._blacklistComponentNames.contains(disabledComponentName)) {
                reactivateComponentNames.add((String)disabledComponentName);
            }
        });
        for (Bundle bundle : bundles) {
            this.disableComponents(bundle, this._blacklistComponentNames);
            this.enableComponents(bundle, reactivateComponentNames);
        }
    }

    private void _performComponentDescriptionDTOOperation(Bundle bundle, Set<String> componentNames, ComponentDescriptionDTOOperator componentDescriptionDTOOperator) {
        componentNames.forEach(componentName -> {
            ComponentDescriptionDTO componentDescriptionDTO = this.serviceComponentRuntime.getComponentDescriptionDTO(bundle, componentName);
            if (componentDescriptionDTO != null) {
                componentDescriptionDTOOperator.operate(componentDescriptionDTO);
            }
        });
    }

    private class ComponentDisablingBundleListener
    implements BundleListener {
        private ComponentDisablingBundleListener() {
        }

        public void bundleChanged(BundleEvent bundleEvent) {
            if (bundleEvent.getType() != 2) {
                return;
            }
            Bundle bundle = bundleEvent.getBundle();
            ComponentBlacklistImpl.this.disableComponents(bundle, ComponentBlacklistImpl.this._blacklistComponentNames);
        }
    }

    private static interface ComponentDescriptionDTOOperator {
        public void operate(ComponentDescriptionDTO var1);
    }
}

