/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.multiple.internal.bootstrap;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cache.PortalCacheBootstrapLoader;
import com.liferay.portal.cache.multiple.internal.bootstrap.ClusterLinkBootstrapLoaderHelperUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Properties;

public class ClusterLinkPortalCacheBootstrapLoader
implements PortalCacheBootstrapLoader {
    private static final Log _log = LogFactoryUtil.getLog(ClusterLinkPortalCacheBootstrapLoader.class);
    private final boolean _bootstrapAsynchronously;

    public ClusterLinkPortalCacheBootstrapLoader(Properties properties) {
        this._bootstrapAsynchronously = properties != null ? GetterUtil.getBoolean((String)properties.getProperty("bootstrapAsynchronously"), (boolean)true) : true;
    }

    public boolean isAsynchronous() {
        return this._bootstrapAsynchronously;
    }

    public void loadPortalCache(String portalCacheManagerName, String portalCacheName) {
        if (ClusterLinkBootstrapLoaderHelperUtil.isSkipped()) {
            return;
        }
        if (this._bootstrapAsynchronously) {
            BootstrapLoaderClientThread bootstrapLoaderClientThread = new BootstrapLoaderClientThread(portalCacheManagerName, portalCacheName);
            bootstrapLoaderClientThread.start();
        } else {
            this.doLoad(portalCacheManagerName, portalCacheName);
        }
    }

    protected void doLoad(String portalCacheManagerName, String portalCacheName) {
        block3: {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Bootstraping " + portalCacheName));
            }
            try {
                ClusterLinkBootstrapLoaderHelperUtil.loadCachesFromCluster(portalCacheManagerName, portalCacheName);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to load cache data from the cluster", (Throwable)e);
            }
        }
    }

    private class BootstrapLoaderClientThread
    extends Thread {
        private final String _portalCacheManagerName;
        private final String _portalCacheName;

        public BootstrapLoaderClientThread(String portalCacheManagerName, String portalCacheName) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Bootstrap loader client thread for cache ", portalCacheName, " from cache manager ", portalCacheManagerName}));
            }
            this._portalCacheManagerName = portalCacheManagerName;
            this._portalCacheName = portalCacheName;
            this.setDaemon(true);
            this.setName(StringBundler.concat((String[])new String[]{BootstrapLoaderClientThread.class.getName(), " - ", portalCacheManagerName, " - ", portalCacheName}));
            this.setPriority(5);
        }

        @Override
        public void run() {
            block2: {
                try {
                    ClusterLinkPortalCacheBootstrapLoader.this.doLoad(this._portalCacheManagerName, this._portalCacheName);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)"Unable to asynchronously stream bootstrap", (Throwable)e);
                }
            }
        }
    }
}

