/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.internal.dao.orm;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.cache.internal.dao.orm.EmptyResult;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LRUMap;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.servlet.filters.threadlocal.ThreadLocalFilterThreadLocal;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={CacheRegistryItem.class, FinderCache.class, FinderCacheImpl.class})
public class FinderCacheImpl
implements CacheRegistryItem,
FinderCache,
PortalCacheManagerListener {
    private static final String _GROUP_KEY_PREFIX = FinderCache.class.getName() + ".";
    private static final Log _log = LogFactoryUtil.getLog(FinderCacheImpl.class);
    private static final MethodKey _clearDSLQueryCacheMethodKey = new MethodKey(FinderCacheUtil.class, "clearDSLQueryCache", new Class[]{String.class});
    private final Map<String, ArgumentsResolver> _argumentsResolvers = new ConcurrentHashMap<String, ArgumentsResolver>();
    private ServiceTracker<ArgumentsResolver, ArgumentsResolver> _argumentsResolverServiceTracker;
    private volatile CacheKeyGenerator _baseModelCacheKeyGenerator;
    private BundleContext _bundleContext;
    private volatile CacheKeyGenerator _cacheKeyGenerator;
    @Reference
    private ClusterExecutor _clusterExecutor;
    private boolean _dbPartitionEnabled;
    private final Map<String, Set<String>> _dslQueryCacheNamesMap = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Map<String, FinderPath>> _finderPathsMap = new ConcurrentHashMap<String, Map<String, FinderPath>>();
    private ThreadLocal<LRUMap<LocalCacheKey, Serializable>> _localCache;
    private final Map<String, String> _modelImplClassNames = new ConcurrentHashMap<String, String>();
    private final Map<String, Boolean> _modelImplClassSharded = new ConcurrentHashMap<String, Boolean>();
    @Reference
    private MultiVMPool _multiVMPool;
    private final ConcurrentMap<String, PortalCache<Serializable, Serializable>> _portalCaches = new ConcurrentHashMap<String, PortalCache<Serializable, Serializable>>();
    @Reference
    private Props _props;
    private boolean _valueObjectFinderCacheEnabled;
    private int _valueObjectFinderCacheListThreshold;

    public void clearByEntityCache(String className) {
        this.clearLocalCache();
        this._clearCache(className);
        this._clearCache(this._getCacheNameWithPagination(className));
        this._clearCache(this._getCacheNameWithoutPagination(className));
        this._clearDSLQueryCache(className);
    }

    public void clearCache() {
        this.clearLocalCache();
        for (PortalCache portalCache : this._portalCaches.values()) {
            portalCache.removeAll();
        }
    }

    public void clearCache(Class<?> clazz) {
        this.clearByEntityCache(clazz.getName());
    }

    public void clearDSLQueryCache(String tableName) {
        String modelImplClassName = this._modelImplClassNames.get(tableName);
        if (modelImplClassName != null) {
            this._clearDSLQueryCache(modelImplClassName);
        }
        if (this._clusterExecutor.isEnabled() && ClusterInvokeThreadLocal.isEnabled()) {
            try {
                ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)new MethodHandler(_clearDSLQueryCacheMethodKey, new Object[]{tableName}), (boolean)true);
                clusterRequest.setFireAndForget(true);
                this._clusterExecutor.execute(clusterRequest);
            }
            catch (Throwable throwable) {
                _log.error((Object)throwable, throwable);
            }
        }
    }

    public void clearLocalCache() {
        if (this._isLocalCacheEnabled()) {
            this._localCache.remove();
        }
    }

    public void dispose() {
        this._portalCaches.clear();
    }

    public String getRegistryName() {
        return FinderCache.class.getName();
    }

    public Object getResult(FinderPath finderPath, Object[] args, BasePersistence<?> basePersistence) {
        PortalCache<Serializable, Serializable> portalCache;
        if (!this._valueObjectFinderCacheEnabled || !CacheRegistryUtil.isActive()) {
            return null;
        }
        Serializable cacheKey = this._encodeCacheKey(finderPath, args);
        Serializable cacheValue = null;
        Map localCache = null;
        LocalCacheKey localCacheKey = null;
        if (this._isLocalCacheEnabled()) {
            localCache = (Map)this._localCache.get();
            localCacheKey = new LocalCacheKey(finderPath.getCacheName(), cacheKey);
            cacheValue = (Serializable)localCache.get(localCacheKey);
        }
        if (cacheValue == null && (cacheValue = (Serializable)(portalCache = this._getPortalCache(finderPath.getCacheName())).get(cacheKey)) != null && localCache != null) {
            localCache.put(localCacheKey, cacheValue);
        }
        if (cacheValue == null) {
            return null;
        }
        if (cacheValue instanceof EmptyResult) {
            EmptyResult emptyResult = (EmptyResult)cacheValue;
            if (emptyResult.matches(args)) {
                return Collections.emptyList();
            }
            return null;
        }
        if (!finderPath.isBaseModelResult()) {
            return cacheValue;
        }
        Map.Entry cacheResultEntry = (Map.Entry)((Object)cacheValue);
        if ((cacheValue = (Serializable)cacheResultEntry.getValue()) instanceof List) {
            List primaryKeys = (List)((Object)cacheValue);
            HashSet primaryKeysSet = new HashSet(primaryKeys);
            Map map = basePersistence.fetchByPrimaryKeys(primaryKeysSet);
            if (map.size() < primaryKeysSet.size()) {
                return null;
            }
            ArrayList list = new ArrayList(primaryKeys.size());
            for (Serializable curPrimaryKey : primaryKeys) {
                list.add(map.get(curPrimaryKey));
            }
            return Collections.unmodifiableList(list);
        }
        return basePersistence.fetchByPrimaryKey(cacheValue);
    }

    public void init() {
    }

    public void invalidate() {
        this.clearCache();
    }

    public void notifyPortalCacheAdded(String portalCacheName) {
    }

    public void notifyPortalCacheRemoved(String portalCacheName) {
        if (portalCacheName.startsWith(_GROUP_KEY_PREFIX)) {
            this._portalCaches.remove(portalCacheName.substring(_GROUP_KEY_PREFIX.length()));
        }
    }

    public void putResult(FinderPath finderPath, Object[] args, Object result) {
        Map<String, FinderPath> originalFinderPaths;
        if (!this._valueObjectFinderCacheEnabled || !CacheRegistryUtil.isActive() || result == null) {
            return;
        }
        Serializable cacheValue = (AbstractMap.SimpleEntry<String, Serializable>)result;
        if (result instanceof BaseModel) {
            BaseModel model = (BaseModel)result;
            cacheValue = finderPath.isBaseModelResult() ? new AbstractMap.SimpleEntry<String, Serializable>(model.getModelClassName(), model.getPrimaryKeyObj()) : model.getPrimaryKeyObj();
        } else if (result instanceof List) {
            List objects = (List)result;
            if (objects.isEmpty()) {
                cacheValue = new EmptyResult(args);
            } else {
                if (objects.size() > this._valueObjectFinderCacheListThreshold && this._valueObjectFinderCacheListThreshold > 0) {
                    this._removeResult(finderPath, args);
                    return;
                }
                if (finderPath.isBaseModelResult()) {
                    String baseModelClassName = null;
                    ArrayList<Serializable> primaryKeys = new ArrayList<Serializable>(objects.size());
                    for (Object object : objects) {
                        BaseModel baseModel = (BaseModel)object;
                        if (baseModelClassName == null) {
                            baseModelClassName = baseModel.getModelClassName();
                        }
                        primaryKeys.add(baseModel.getPrimaryKeyObj());
                    }
                    cacheValue = new AbstractMap.SimpleEntry(baseModelClassName, primaryKeys);
                }
            }
        }
        String cacheName = finderPath.getCacheName();
        String cacheKeyPrefix = finderPath.getCacheKeyPrefix();
        Map<String, FinderPath> finderPaths = this._finderPathsMap.get(cacheName);
        if (finderPaths == null && (originalFinderPaths = this._finderPathsMap.putIfAbsent(cacheName, finderPaths = new ConcurrentHashMap<String, FinderPath>())) != null) {
            finderPaths = originalFinderPaths;
        }
        if (!finderPaths.containsKey(cacheKeyPrefix)) {
            if (cacheKeyPrefix.startsWith("dslQuery")) {
                String[] tableNames = FinderPath.decodeDSLQueryCacheName((String)cacheName);
                String[] modelImplClassNames = new String[tableNames.length];
                for (int i = 0; i < tableNames.length; ++i) {
                    String tableName = tableNames[i];
                    String modelImplClassName = this._modelImplClassNames.get(tableName);
                    if (modelImplClassName == null) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Unable to find corresponding model impl class for table " + tableName));
                        }
                        return;
                    }
                    modelImplClassNames[i] = modelImplClassName;
                }
                for (String modelImplClassName : modelImplClassNames) {
                    Set dslQueryCacheNames = this._dslQueryCacheNamesMap.computeIfAbsent(modelImplClassName, key -> Collections.newSetFromMap(new ConcurrentHashMap()));
                    dslQueryCacheNames.add(cacheName);
                }
            }
            finderPaths.putIfAbsent(cacheKeyPrefix, finderPath);
        }
        Serializable cacheKey = this._encodeCacheKey(finderPath, args);
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            localCache.put(new LocalCacheKey(finderPath.getCacheName(), cacheKey), cacheValue);
        }
        PortalCacheHelperUtil.putWithoutReplicator(this._getPortalCache(finderPath.getCacheName()), (Serializable)cacheKey, cacheValue);
    }

    public void removeByEntityCache(String className, BaseModel<?> baseModel) {
        ArgumentsResolver argumentsResolver = this._argumentsResolvers.get(className);
        if (argumentsResolver == null) {
            this.clearByEntityCache(className);
            return;
        }
        this.clearLocalCache();
        this._clearCache(this._getCacheNameWithPagination(className));
        this._clearCache(this._getCacheNameWithoutPagination(className));
        this._clearDSLQueryCache(className);
        for (FinderPath finderPath : this._getFinderPaths(className)) {
            this.removeResult(finderPath, argumentsResolver.getArguments(finderPath, baseModel, false, false));
            this.removeResult(finderPath, argumentsResolver.getArguments(finderPath, baseModel, true, true));
        }
    }

    public void removeCache(String className) {
        this._portalCaches.remove(className);
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        this._multiVMPool.removePortalCache(groupKey);
        this._finderPathsMap.remove(className);
    }

    public void removeCacheByEntityCache(String cacheName) {
        this.removeCache(cacheName);
        this.removeCache(this._getCacheNameWithPagination(cacheName));
        this.removeCache(this._getCacheNameWithoutPagination(cacheName));
        Set<String> dslQueryCacheNames = this._dslQueryCacheNamesMap.remove(cacheName);
        if (dslQueryCacheNames != null) {
            for (String dslQueryCacheName : dslQueryCacheNames) {
                this.removeCache(dslQueryCacheName);
            }
        }
    }

    public void removeResult(FinderPath finderPath, Object[] args) {
        if (!this._valueObjectFinderCacheEnabled || !CacheRegistryUtil.isActive()) {
            return;
        }
        this._removeResult(finderPath, args);
    }

    public void updateByEntityCache(String className, BaseModel<?> baseModel) {
        if (!this._valueObjectFinderCacheEnabled) {
            return;
        }
        ArgumentsResolver argumentsResolver = this._argumentsResolvers.get(className);
        if (argumentsResolver == null) {
            this.clearByEntityCache(className);
            return;
        }
        this.clearLocalCache();
        this._clearCache(this._getCacheNameWithPagination(className));
        this._clearDSLQueryCache(className);
        HashSet<FinderPath> finderPaths = new HashSet<FinderPath>();
        finderPaths.addAll(this._getFinderPaths(this._getCacheNameWithoutPagination(className)));
        finderPaths.addAll(this._getFinderPaths(className));
        for (FinderPath finderPath : finderPaths) {
            if (baseModel.isNew()) {
                this._removeResult(finderPath, argumentsResolver.getArguments(finderPath, baseModel, false, false));
                continue;
            }
            this._removeResult(finderPath, argumentsResolver.getArguments(finderPath, baseModel, true, false));
            this._removeResult(finderPath, argumentsResolver.getArguments(finderPath, baseModel, true, true));
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._dbPartitionEnabled = GetterUtil.getBoolean((String)this._props.get("database.partition.enabled"));
        this._valueObjectFinderCacheEnabled = GetterUtil.getBoolean((String)this._props.get("value.object.finder.cache.enabled"));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)this._props.get("value.object.finder.cache.list.threshold"));
        if (this._valueObjectFinderCacheListThreshold == 0) {
            this._valueObjectFinderCacheEnabled = false;
        }
        int localCacheMaxSize = GetterUtil.getInteger((String)this._props.get("value.object.finder.thread.local.cache.max.size"));
        this._localCache = !this._dbPartitionEnabled && localCacheMaxSize > 0 ? new CentralizedThreadLocal(FinderCacheImpl.class + "._localCache", () -> new LRUMap(localCacheMaxSize)) : null;
        PortalCacheManager portalCacheManager = this._multiVMPool.getPortalCacheManager();
        portalCacheManager.registerPortalCacheManagerListener((PortalCacheManagerListener)this);
        this._argumentsResolverServiceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, ArgumentsResolver.class, (ServiceTrackerCustomizer)new ArgumentsResolverServiceTrackerCustomizer());
    }

    @Deactivate
    protected void deactivate() {
        this._argumentsResolverServiceTracker.close();
    }

    private void _clearCache(String cacheName) {
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(cacheName);
        portalCache.removeAll();
    }

    private void _clearDSLQueryCache(String className) {
        Set<String> dslQueryCacheNames = this._dslQueryCacheNamesMap.get(className);
        if (dslQueryCacheNames != null) {
            for (String dslQueryCacheName : dslQueryCacheNames) {
                this._clearCache(dslQueryCacheName);
            }
        }
    }

    private Serializable _encodeCacheKey(FinderPath finderPath, Object[] arguments) {
        CacheKeyGenerator cacheKeyGenerator = this._getCacheKeyGenerator(finderPath.isBaseModelResult());
        String[] keys = new String[arguments.length * 2];
        for (int i = 0; i < arguments.length; ++i) {
            int index = i * 2;
            keys[index] = ".";
            keys[index + 1] = StringUtil.toHexString((Object)arguments[i]);
        }
        return cacheKeyGenerator.getCacheKey(new String[]{finderPath.getCacheKeyPrefix(), StringUtil.toHexString((Object)cacheKeyGenerator.getCacheKey(keys))});
    }

    private CacheKeyGenerator _getCacheKeyGenerator(boolean baseModel) {
        if (baseModel) {
            CacheKeyGenerator cacheKeyGenerator = this._baseModelCacheKeyGenerator;
            if (cacheKeyGenerator == null) {
                this._baseModelCacheKeyGenerator = cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)(FinderCache.class.getName() + "#BaseModel"));
            }
            return cacheKeyGenerator;
        }
        CacheKeyGenerator cacheKeyGenerator = this._cacheKeyGenerator;
        if (cacheKeyGenerator == null) {
            this._cacheKeyGenerator = cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)FinderCache.class.getName());
        }
        return cacheKeyGenerator;
    }

    private String _getCacheNameWithoutPagination(String cacheName) {
        return cacheName.concat(".List2");
    }

    private String _getCacheNameWithPagination(String cacheName) {
        return cacheName.concat(".List1");
    }

    private Collection<FinderPath> _getFinderPaths(String cacheName) {
        Map<String, FinderPath> finderPaths = this._finderPathsMap.get(cacheName);
        if (finderPaths == null) {
            return Collections.emptySet();
        }
        return finderPaths.values();
    }

    private PortalCache<Serializable, Serializable> _getPortalCache(String className) {
        String groupKey;
        PortalCache<Serializable, Serializable> previousPortalCache;
        PortalCache portalCache = (PortalCache)this._portalCaches.get(className);
        if (portalCache != null) {
            return portalCache;
        }
        boolean sharded = false;
        if (this._dbPartitionEnabled) {
            String modleImplClassName = className;
            if (className.endsWith(".List1") || className.endsWith(".List2")) {
                modleImplClassName = className.substring(0, className.length() - 6);
            }
            sharded = GetterUtil.getBoolean((Object)this._modelImplClassSharded.get(modleImplClassName));
        }
        if ((previousPortalCache = this._portalCaches.putIfAbsent(className, (PortalCache<Serializable, Serializable>)(portalCache = this._multiVMPool.getPortalCache(groupKey = _GROUP_KEY_PREFIX.concat(className), false, sharded)))) != null) {
            return previousPortalCache;
        }
        return portalCache;
    }

    private boolean _isLocalCacheEnabled() {
        if (this._localCache == null) {
            return false;
        }
        return ThreadLocalFilterThreadLocal.isFilterInvoked();
    }

    private void _removeResult(FinderPath finderPath, Object[] args) {
        if (args == null) {
            return;
        }
        Serializable cacheKey = this._encodeCacheKey(finderPath, args);
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            localCache.remove(new LocalCacheKey(finderPath.getCacheName(), cacheKey));
        }
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(finderPath.getCacheName());
        portalCache.remove(cacheKey);
    }

    private class ArgumentsResolverServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ArgumentsResolver, ArgumentsResolver> {
        private ArgumentsResolverServiceTrackerCustomizer() {
        }

        public ArgumentsResolver addingService(ServiceReference<ArgumentsResolver> serviceReference) {
            ArgumentsResolver argumentsResolver;
            block3: {
                argumentsResolver = (ArgumentsResolver)FinderCacheImpl.this._bundleContext.getService(serviceReference);
                String className = argumentsResolver.getClassName();
                String tableName = argumentsResolver.getTableName();
                FinderCacheImpl.this._argumentsResolvers.put(className, argumentsResolver);
                FinderCacheImpl.this._modelImplClassNames.put(tableName, className);
                if (!Objects.equals(className, tableName)) {
                    Class<?> clazz = argumentsResolver.getClass();
                    ClassLoader classLoader = clazz.getClassLoader();
                    try {
                        Class<?> modelImplClass = classLoader.loadClass(argumentsResolver.getClassName());
                        FinderCacheImpl.this._modelImplClassSharded.put(argumentsResolver.getClassName(), ShardedModel.class.isAssignableFrom(modelImplClass));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn((Throwable)classNotFoundException);
                    }
                }
            }
            return argumentsResolver;
        }

        public void modifiedService(ServiceReference<ArgumentsResolver> serviceReference, ArgumentsResolver argumentsResolver) {
        }

        public void removedService(ServiceReference<ArgumentsResolver> serviceReference, ArgumentsResolver argumentsResolver) {
            FinderCacheImpl.this._argumentsResolvers.remove(argumentsResolver.getClassName());
            FinderCacheImpl.this._modelImplClassNames.remove(argumentsResolver.getTableName());
            FinderCacheImpl.this._bundleContext.ungetService(serviceReference);
        }
    }

    private static class LocalCacheKey {
        private final Serializable _cacheKey;
        private final String _className;

        public boolean equals(Object object) {
            LocalCacheKey localCacheKey = (LocalCacheKey)object;
            return this._className.equals(localCacheKey._className) && this._cacheKey.equals(localCacheKey._cacheKey);
        }

        public int hashCode() {
            return HashUtil.hash((int)this._className.hashCode(), (int)this._cacheKey.hashCode());
        }

        private LocalCacheKey(String className, Serializable cacheKey) {
            this._className = className;
            this._cacheKey = cacheKey;
        }
    }
}

