/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.internal.dao.orm;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.cache.internal.dao.orm.EmptyResult;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.servlet.filters.threadlocal.ThreadLocalFilterThreadLocal;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.map.LRUMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CacheRegistryItem.class, FinderCache.class})
public class FinderCacheImpl
implements CacheRegistryItem,
FinderCache,
PortalCacheManagerListener {
    private static final String _GROUP_KEY_PREFIX = FinderCache.class.getName() + ".";
    private static final Object _NULL_MODEL;
    private EntityCache _entityCache;
    private ThreadLocal<LRUMap> _localCache;
    private MultiVMPool _multiVMPool;
    private final ConcurrentMap<String, PortalCache<Serializable, Serializable>> _portalCaches = new ConcurrentHashMap<String, PortalCache<Serializable, Serializable>>();
    private Props _props;
    private boolean _valueObjectFinderCacheEnabled;
    private int _valueObjectFinderCacheListThreshold;

    public void clearCache() {
        this.clearLocalCache();
        for (PortalCache portalCache : this._portalCaches.values()) {
            portalCache.removeAll();
        }
    }

    public void clearCache(String className) {
        this.clearLocalCache();
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(className);
        portalCache.removeAll();
    }

    public void clearLocalCache() {
        if (this._isLocalCacheEnabled()) {
            this._localCache.remove();
        }
    }

    public void dispose() {
        this._portalCaches.clear();
    }

    public String getRegistryName() {
        return FinderCache.class.getName();
    }

    public Object getResult(FinderPath finderPath, Object[] args, BasePersistenceImpl<? extends BaseModel<?>> basePersistenceImpl) {
        PortalCache<Serializable, Serializable> portalCache;
        if (!(this._valueObjectFinderCacheEnabled && finderPath.isFinderCacheEnabled() && CacheRegistryUtil.isActive())) {
            return null;
        }
        Serializable cacheValue = null;
        String encodedArguments = finderPath.encodeArguments(args);
        Map localCache = null;
        Serializable localCacheKey = null;
        if (this._isLocalCacheEnabled()) {
            localCache = (Map)this._localCache.get();
            localCacheKey = finderPath.encodeLocalCacheKey(encodedArguments);
            cacheValue = (Serializable)localCache.get(localCacheKey);
        }
        if (cacheValue == null && (cacheValue = (Serializable)(portalCache = this._getPortalCache(finderPath.getCacheName())).get(finderPath.encodeCacheKey(encodedArguments))) != null && localCache != null) {
            localCache.put(localCacheKey, cacheValue);
        }
        if (cacheValue == null) {
            return null;
        }
        if (cacheValue instanceof EmptyResult) {
            EmptyResult emptyResult = (EmptyResult)cacheValue;
            if (emptyResult.matches(args)) {
                return Collections.emptyList();
            }
            return null;
        }
        if (!finderPath.isBaseModelResult()) {
            return cacheValue;
        }
        if (cacheValue instanceof List) {
            List primaryKeys = (List)((Object)cacheValue);
            HashSet primaryKeysSet = new HashSet(primaryKeys);
            Map map = basePersistenceImpl.fetchByPrimaryKeys(primaryKeysSet);
            if (map.size() < primaryKeysSet.size()) {
                return null;
            }
            ArrayList list = new ArrayList(primaryKeys.size());
            for (Serializable curPrimaryKey : primaryKeys) {
                list.add(map.get(curPrimaryKey));
            }
            return Collections.unmodifiableList(list);
        }
        Serializable result = this._entityCache.loadResult(finderPath.isEntityCacheEnabled(), finderPath.getResultClass(), cacheValue, basePersistenceImpl);
        if (result == _NULL_MODEL) {
            return null;
        }
        return result;
    }

    public void init() {
    }

    public void invalidate() {
        this.clearCache();
    }

    public void notifyPortalCacheAdded(String portalCacheName) {
    }

    public void notifyPortalCacheRemoved(String portalCacheName) {
        if (portalCacheName.startsWith(_GROUP_KEY_PREFIX)) {
            this._portalCaches.remove(portalCacheName.substring(_GROUP_KEY_PREFIX.length()));
        }
    }

    public void putResult(FinderPath finderPath, Object[] args, Object result) {
        this.putResult(finderPath, args, result, true);
    }

    public void putResult(FinderPath finderPath, Object[] args, Object result, boolean quiet) {
        if (!(this._valueObjectFinderCacheEnabled && finderPath.isFinderCacheEnabled() && CacheRegistryUtil.isActive() && result != null)) {
            return;
        }
        ArrayList<Serializable> cacheValue = (ArrayList<Serializable>)result;
        if (result instanceof BaseModel) {
            BaseModel model = (BaseModel)result;
            cacheValue = model.getPrimaryKeyObj();
        } else if (result instanceof List) {
            List objects = (List)result;
            if (objects.isEmpty()) {
                cacheValue = new EmptyResult(args);
            } else {
                if (objects.size() > this._valueObjectFinderCacheListThreshold && this._valueObjectFinderCacheListThreshold > 0) {
                    this._removeResult(finderPath, args);
                    return;
                }
                if (finderPath.isBaseModelResult()) {
                    ArrayList<Serializable> primaryKeys = new ArrayList<Serializable>(objects.size());
                    for (Object object : objects) {
                        BaseModel baseModel = (BaseModel)object;
                        primaryKeys.add(baseModel.getPrimaryKeyObj());
                    }
                    cacheValue = primaryKeys;
                }
            }
        }
        String encodedArguments = finderPath.encodeArguments(args);
        Serializable cacheKey = finderPath.encodeCacheKey(encodedArguments);
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            localCache.put(finderPath.encodeLocalCacheKey(encodedArguments), cacheValue);
        }
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(finderPath.getCacheName());
        if (quiet) {
            PortalCacheHelperUtil.putWithoutReplicator(portalCache, (Serializable)cacheKey, (Object)cacheValue);
        } else {
            portalCache.put(cacheKey, (Object)cacheValue);
        }
    }

    public void removeCache(String className) {
        this._portalCaches.remove(className);
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        this._multiVMPool.removePortalCache(groupKey);
    }

    public void removeResult(FinderPath finderPath, Object[] args) {
        if (!(this._valueObjectFinderCacheEnabled && finderPath.isFinderCacheEnabled() && CacheRegistryUtil.isActive())) {
            return;
        }
        this._removeResult(finderPath, args);
    }

    @Activate
    @Modified
    protected void activate() {
        int localCacheMaxSize;
        this._valueObjectFinderCacheEnabled = GetterUtil.getBoolean((String)this._props.get("value.object.finder.cache.enabled"));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)this._props.get("value.object.finder.cache.list.threshold"));
        if (this._valueObjectFinderCacheListThreshold == 0) {
            this._valueObjectFinderCacheEnabled = false;
        }
        this._localCache = (localCacheMaxSize = GetterUtil.getInteger((String)this._props.get("value.object.finder.thread.local.cache.max.size"))) > 0 ? new CentralizedThreadLocal(FinderCacheImpl.class + "._localCache", () -> new LRUMap(localCacheMaxSize)) : null;
        PortalCacheManager portalCacheManager = this._multiVMPool.getPortalCacheManager();
        portalCacheManager.registerPortalCacheManagerListener((PortalCacheManagerListener)this);
    }

    @Reference(unbind="-")
    protected void setEntityCache(EntityCache entityCache) {
        this._entityCache = entityCache;
    }

    @Reference(unbind="-")
    protected void setMultiVMPool(MultiVMPool multiVMPool) {
        this._multiVMPool = multiVMPool;
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._props = props;
    }

    private PortalCache<Serializable, Serializable> _getPortalCache(String className) {
        PortalCache portalCache = (PortalCache)this._portalCaches.get(className);
        if (portalCache != null) {
            return portalCache;
        }
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        portalCache = this._multiVMPool.getPortalCache(groupKey);
        PortalCache<Serializable, Serializable> previousPortalCache = this._portalCaches.putIfAbsent(className, (PortalCache<Serializable, Serializable>)portalCache);
        if (previousPortalCache != null) {
            return previousPortalCache;
        }
        return portalCache;
    }

    private boolean _isLocalCacheEnabled() {
        if (this._localCache == null) {
            return false;
        }
        return ThreadLocalFilterThreadLocal.isFilterInvoked();
    }

    private void _removeResult(FinderPath finderPath, Object[] args) {
        String encodedArguments = finderPath.encodeArguments(args);
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            localCache.remove(finderPath.encodeLocalCacheKey(encodedArguments));
        }
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(finderPath.getCacheName());
        portalCache.remove(finderPath.encodeCacheKey(encodedArguments));
    }

    static {
        try {
            Field field = BasePersistenceImpl.class.getDeclaredField("nullModel");
            field.setAccessible(true);
            _NULL_MODEL = field.get(null);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

