/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.internal;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.resiliency.spi.cache.SPIPortalCacheManagerConfigurator;
import java.io.Serializable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={MultiVMPool.class})
public class MultiVMPoolImpl
implements MultiVMPool {
    private static final Log _log = LogFactoryUtil.getLog(MultiVMPoolImpl.class);
    private BundleContext _bundleContext;
    private PortalCacheManager<? extends Serializable, ? extends Serializable> _portalCacheManager;
    private ServiceTracker<SPIPortalCacheManagerConfigurator, SPIPortalCacheManagerConfigurator> _serviceTracker;
    private volatile PortalCacheManager<? extends Serializable, ? extends Serializable> _spiPortalCacheManager;

    public void clear() {
        PortalCacheManager<? extends Serializable, ? extends Serializable> portalCacheManager = this.getPortalCacheManager();
        portalCacheManager.clearAll();
    }

    public PortalCache<? extends Serializable, ? extends Serializable> getPortalCache(String portalCacheName) {
        PortalCacheManager<? extends Serializable, ? extends Serializable> portalCacheManager = this.getPortalCacheManager();
        return portalCacheManager.getPortalCache(portalCacheName);
    }

    public PortalCache<? extends Serializable, ? extends Serializable> getPortalCache(String portalCacheName, boolean blocking) {
        PortalCacheManager<? extends Serializable, ? extends Serializable> portalCacheManager = this.getPortalCacheManager();
        return portalCacheManager.getPortalCache(portalCacheName, blocking);
    }

    public PortalCache<? extends Serializable, ? extends Serializable> getPortalCache(String portalCacheName, boolean blocking, boolean mvcc) {
        PortalCacheManager<? extends Serializable, ? extends Serializable> portalCacheManager = this.getPortalCacheManager();
        return portalCacheManager.getPortalCache(portalCacheName, blocking, mvcc);
    }

    public PortalCacheManager<? extends Serializable, ? extends Serializable> getPortalCacheManager() {
        PortalCacheManager<? extends Serializable, ? extends Serializable> portalCacheManager = this._spiPortalCacheManager;
        if (portalCacheManager != null) {
            return portalCacheManager;
        }
        return this._portalCacheManager;
    }

    public void removePortalCache(String portalCacheName) {
        PortalCacheManager<? extends Serializable, ? extends Serializable> portalCacheManager = this.getPortalCacheManager();
        portalCacheManager.removePortalCache(portalCacheName);
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        if (SPIUtil.isSPI()) {
            this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, SPIPortalCacheManagerConfigurator.class, (ServiceTrackerCustomizer)new SPIPortalCacheManagerConfiguratorServiceTrackerCustomizer());
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceTracker != null) {
            this._serviceTracker.close();
            this._serviceTracker = null;
        }
    }

    @Reference(target="(portal.cache.manager.name=MULTI_VM_PORTAL_CACHE_MANAGER)", unbind="-")
    protected void setPortalCacheManager(PortalCacheManager<? extends Serializable, ? extends Serializable> portalCacheManager) {
        this._portalCacheManager = portalCacheManager;
    }

    private class SPIPortalCacheManagerConfiguratorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<SPIPortalCacheManagerConfigurator, SPIPortalCacheManagerConfigurator> {
        private SPIPortalCacheManagerConfiguratorServiceTrackerCustomizer() {
        }

        public SPIPortalCacheManagerConfigurator addingService(ServiceReference<SPIPortalCacheManagerConfigurator> serviceReference) {
            SPIPortalCacheManagerConfigurator spiPortalCacheManagerConfigurator = (SPIPortalCacheManagerConfigurator)MultiVMPoolImpl.this._bundleContext.getService(serviceReference);
            try {
                PortalCacheManager portalCacheManager = spiPortalCacheManagerConfigurator.createSPIPortalCacheManager(MultiVMPoolImpl.this._portalCacheManager);
                if (portalCacheManager != MultiVMPoolImpl.this._portalCacheManager) {
                    MultiVMPoolImpl.this._spiPortalCacheManager = portalCacheManager;
                    MultiVMPoolImpl.this._portalCacheManager.clearAll();
                }
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to create SPI portal cache manager", (Throwable)exception);
            }
            return spiPortalCacheManagerConfigurator;
        }

        public void modifiedService(ServiceReference<SPIPortalCacheManagerConfigurator> reference, SPIPortalCacheManagerConfigurator service) {
        }

        public void removedService(ServiceReference<SPIPortalCacheManagerConfigurator> reference, SPIPortalCacheManagerConfigurator service) {
            MultiVMPoolImpl.this._spiPortalCacheManager = null;
        }
    }
}

