/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.internal.dao.orm;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.servlet.filters.threadlocal.ThreadLocalFilterThreadLocal;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.map.LRUMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CacheRegistryItem.class, FinderCache.class})
public class FinderCacheImpl
implements PortalCacheManagerListener,
CacheRegistryItem,
FinderCache {
    private static final String _GROUP_KEY_PREFIX = FinderCache.class.getName() + ".";
    private static final Object _NULL_MODEL;
    private EntityCache _entityCache;
    private ThreadLocal<LRUMap> _localCache;
    private MultiVMPool _multiVMPool;
    private final ConcurrentMap<String, PortalCache<Serializable, Serializable>> _portalCaches = new ConcurrentHashMap<String, PortalCache<Serializable, Serializable>>();
    private Props _props;
    private boolean _valueObjectFinderCacheEnabled;
    private int _valueObjectFinderCacheListThreshold;

    public void clearCache() {
        this.clearLocalCache();
        for (PortalCache portalCache : this._portalCaches.values()) {
            portalCache.removeAll();
        }
    }

    public void clearCache(String className) {
        this.clearLocalCache();
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(className);
        portalCache.removeAll();
    }

    public void clearLocalCache() {
        if (this._isLocalCacheEnabled()) {
            this._localCache.remove();
        }
    }

    public void dispose() {
        this._portalCaches.clear();
    }

    public String getRegistryName() {
        return FinderCache.class.getName();
    }

    public Object getResult(FinderPath finderPath, Object[] args, BasePersistenceImpl<? extends BaseModel<?>> basePersistenceImpl) {
        PortalCache<Serializable, Serializable> portalCache;
        if (!(this._valueObjectFinderCacheEnabled && finderPath.isFinderCacheEnabled() && CacheRegistryUtil.isActive())) {
            return null;
        }
        String encodedArguments = finderPath.encodeArguments(args);
        Map localCache = null;
        Serializable localCacheKey = null;
        Serializable primaryKey = null;
        if (this._isLocalCacheEnabled()) {
            localCache = (Map)this._localCache.get();
            localCacheKey = finderPath.encodeLocalCacheKey(encodedArguments);
            primaryKey = (Serializable)localCache.get(localCacheKey);
        }
        if (primaryKey == null && (primaryKey = (Serializable)(portalCache = this._getPortalCache(finderPath.getCacheName())).get(finderPath.encodeCacheKey(encodedArguments))) != null && localCache != null) {
            localCache.put(localCacheKey, primaryKey);
        }
        if (primaryKey != null) {
            return this._primaryKeyToResult(finderPath, args, basePersistenceImpl, primaryKey);
        }
        return null;
    }

    public void init() {
    }

    public void invalidate() {
        this.clearCache();
    }

    public void notifyPortalCacheAdded(String portalCacheName) {
    }

    public void notifyPortalCacheRemoved(String portalCacheName) {
        if (portalCacheName.startsWith(_GROUP_KEY_PREFIX)) {
            this._portalCaches.remove(portalCacheName.substring(_GROUP_KEY_PREFIX.length()));
        }
    }

    public void putResult(FinderPath finderPath, Object[] args, Object result) {
        this.putResult(finderPath, args, result, true);
    }

    public void putResult(FinderPath finderPath, Object[] args, Object result, boolean quiet) {
        if (!(this._valueObjectFinderCacheEnabled && finderPath.isFinderCacheEnabled() && CacheRegistryUtil.isActive() && result != null)) {
            return;
        }
        Serializable primaryKey = this._resultToPrimaryKey(args, (Serializable)result);
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(finderPath.getCacheName());
        String encodedArguments = finderPath.encodeArguments(args);
        Serializable cacheKey = finderPath.encodeCacheKey(encodedArguments);
        if (primaryKey == null) {
            if (this._isLocalCacheEnabled()) {
                Map localCache = (Map)this._localCache.get();
                localCache.remove(finderPath.encodeLocalCacheKey(encodedArguments));
            }
            if (quiet) {
                PortalCacheHelperUtil.removeWithoutReplicator(portalCache, (Serializable)cacheKey);
            } else {
                portalCache.remove(cacheKey);
            }
        } else {
            if (this._isLocalCacheEnabled()) {
                Map localCache = (Map)this._localCache.get();
                localCache.put(finderPath.encodeLocalCacheKey(encodedArguments), primaryKey);
            }
            if (quiet) {
                PortalCacheHelperUtil.putWithoutReplicator(portalCache, (Serializable)cacheKey, (Object)primaryKey);
            } else {
                portalCache.put(cacheKey, (Object)primaryKey);
            }
        }
    }

    public void removeCache(String className) {
        this._portalCaches.remove(className);
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        this._multiVMPool.removePortalCache(groupKey);
    }

    public void removeResult(FinderPath finderPath, Object[] args) {
        if (!(this._valueObjectFinderCacheEnabled && finderPath.isFinderCacheEnabled() && CacheRegistryUtil.isActive())) {
            return;
        }
        String encodedArguments = finderPath.encodeArguments(args);
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            localCache.remove(finderPath.encodeLocalCacheKey(encodedArguments));
        }
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(finderPath.getCacheName());
        portalCache.remove(finderPath.encodeCacheKey(encodedArguments));
    }

    @Activate
    @Modified
    protected void activate() {
        int localCacheMaxSize;
        this._valueObjectFinderCacheEnabled = GetterUtil.getBoolean((String)this._props.get("value.object.finder.cache.enabled"));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)this._props.get("value.object.finder.cache.list.threshold"));
        if (this._valueObjectFinderCacheListThreshold == 0) {
            this._valueObjectFinderCacheEnabled = false;
        }
        this._localCache = (localCacheMaxSize = GetterUtil.getInteger((String)this._props.get("value.object.finder.thread.local.cache.max.size"))) > 0 ? new CentralizedThreadLocal(FinderCacheImpl.class + "._localCache", () -> new LRUMap(localCacheMaxSize)) : null;
        PortalCacheManager portalCacheManager = this._multiVMPool.getPortalCacheManager();
        portalCacheManager.registerPortalCacheManagerListener((PortalCacheManagerListener)this);
    }

    @Reference(unbind="-")
    protected void setEntityCache(EntityCache entityCache) {
        this._entityCache = entityCache;
    }

    @Reference(unbind="-")
    protected void setMultiVMPool(MultiVMPool multiVMPool) {
        this._multiVMPool = multiVMPool;
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._props = props;
    }

    private PortalCache<Serializable, Serializable> _getPortalCache(String className) {
        PortalCache portalCache = (PortalCache)this._portalCaches.get(className);
        if (portalCache != null) {
            return portalCache;
        }
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        portalCache = this._multiVMPool.getPortalCache(groupKey);
        PortalCache<Serializable, Serializable> previousPortalCache = this._portalCaches.putIfAbsent(className, (PortalCache<Serializable, Serializable>)portalCache);
        if (previousPortalCache != null) {
            return previousPortalCache;
        }
        return portalCache;
    }

    private boolean _isLocalCacheEnabled() {
        if (this._localCache == null) {
            return false;
        }
        return ThreadLocalFilterThreadLocal.isFilterInvoked();
    }

    private Serializable _primaryKeyToResult(FinderPath finderPath, Object[] args, BasePersistenceImpl<? extends BaseModel<?>> basePersistenceImpl, Serializable primaryKey) {
        if (primaryKey instanceof EmptyResult) {
            EmptyResult emptyResult = (EmptyResult)primaryKey;
            if (emptyResult.matches(args)) {
                return (Serializable)((Object)Collections.emptyList());
            }
            return null;
        }
        if (primaryKey instanceof List) {
            List primaryKeys = (List)((Object)primaryKey);
            HashSet primaryKeysSet = new HashSet(primaryKeys);
            Map map = basePersistenceImpl.fetchByPrimaryKeys(primaryKeysSet);
            if (map.size() < primaryKeysSet.size()) {
                return null;
            }
            ArrayList list = new ArrayList(primaryKeys.size());
            for (Serializable curPrimaryKey : primaryKeys) {
                list.add(map.get(curPrimaryKey));
            }
            return (Serializable)((Object)Collections.unmodifiableList(list));
        }
        if (BaseModel.class.isAssignableFrom(finderPath.getResultClass())) {
            Serializable result = this._entityCache.loadResult(finderPath.isEntityCacheEnabled(), finderPath.getResultClass(), primaryKey, basePersistenceImpl);
            if (result == _NULL_MODEL) {
                return null;
            }
            return result;
        }
        return primaryKey;
    }

    private Serializable _resultToPrimaryKey(Object[] args, Serializable result) {
        if (result instanceof BaseModel) {
            BaseModel model = (BaseModel)result;
            return model.getPrimaryKeyObj();
        }
        if (result instanceof List) {
            List list = (List)((Object)result);
            if (list.isEmpty()) {
                return new EmptyResult(args);
            }
            if (list.size() > this._valueObjectFinderCacheListThreshold && this._valueObjectFinderCacheListThreshold > 0) {
                return null;
            }
            ArrayList<Serializable> cachedList = new ArrayList<Serializable>(list.size());
            for (Serializable curResult : list) {
                Serializable primaryKey = this._resultToPrimaryKey(args, curResult);
                cachedList.add(primaryKey);
            }
            return cachedList;
        }
        return result;
    }

    static {
        try {
            Field field = BasePersistenceImpl.class.getDeclaredField("nullModel");
            field.setAccessible(true);
            _NULL_MODEL = field.get(null);
        }
        catch (ReflectiveOperationException roe) {
            throw new ExceptionInInitializerError(roe);
        }
    }

    private static class EmptyResult
    implements Externalizable {
        private Object[] _args;

        public EmptyResult() {
        }

        public boolean matches(Object[] args) {
            if (args.length != this._args.length) {
                return false;
            }
            for (int i = 0; i < this._args.length; ++i) {
                if (Objects.equals(args[i], this._args[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
            this._args = (Object[])objectInput.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this._args);
        }

        private EmptyResult(Object[] args) {
            this._args = args;
        }
    }
}

