/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.internal.dao.orm;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.servlet.filters.threadlocal.ThreadLocalFilterThreadLocal;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.map.LRUMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CacheRegistryItem.class, EntityCache.class})
public class EntityCacheImpl
implements PortalCacheManagerListener,
CacheRegistryItem,
EntityCache {
    private static final String _GROUP_KEY_PREFIX = EntityCache.class.getName() + ".";
    private static final Log _log = LogFactoryUtil.getLog(EntityCacheImpl.class);
    private ThreadLocal<LRUMap> _localCache;
    private MultiVMPool _multiVMPool;
    private final ConcurrentMap<String, PortalCache<Serializable, Serializable>> _portalCaches = new ConcurrentHashMap<String, PortalCache<Serializable, Serializable>>();
    private Props _props;
    private boolean _valueObjectEntityBlockingCacheEnabled;
    private boolean _valueObjectEntityCacheEnabled;
    private boolean _valueObjectMVCCEntityCacheEnabled;

    public void clearCache() {
        this.clearLocalCache();
        for (PortalCache portalCache : this._portalCaches.values()) {
            portalCache.removeAll();
        }
    }

    public void clearCache(Class<?> clazz) {
        this.clearLocalCache();
        PortalCache<Serializable, Serializable> portalCache = this.getPortalCache(clazz);
        portalCache.removeAll();
    }

    public void clearLocalCache() {
        if (this._isLocalCacheEnabled()) {
            this._localCache.remove();
        }
    }

    public void dispose() {
        this._portalCaches.clear();
    }

    public PortalCache<Serializable, Serializable> getPortalCache(Class<?> clazz) {
        PortalCache<Serializable, Serializable> previousPortalCache;
        String className = clazz.getName();
        PortalCache portalCache = (PortalCache)this._portalCaches.get(className);
        if (portalCache != null) {
            return portalCache;
        }
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        boolean mvcc = false;
        if (this._valueObjectMVCCEntityCacheEnabled && MVCCModel.class.isAssignableFrom(clazz)) {
            mvcc = true;
        }
        if ((previousPortalCache = this._portalCaches.putIfAbsent(className, (PortalCache<Serializable, Serializable>)(portalCache = this._multiVMPool.getPortalCache(groupKey, this._valueObjectEntityBlockingCacheEnabled, mvcc)))) != null) {
            return previousPortalCache;
        }
        return portalCache;
    }

    public String getRegistryName() {
        return EntityCache.class.getName();
    }

    public Serializable getResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey) {
        if (!(this._valueObjectEntityCacheEnabled && entityCacheEnabled && CacheRegistryUtil.isActive())) {
            return null;
        }
        Object result = null;
        Map localCache = null;
        LocalCacheKey localCacheKey = null;
        if (this._isLocalCacheEnabled()) {
            localCache = (Map)this._localCache.get();
            localCacheKey = new LocalCacheKey(clazz.getName(), primaryKey);
            result = (Serializable)localCache.get(localCacheKey);
        }
        if (result == null) {
            PortalCache<Serializable, Serializable> portalCache = this.getPortalCache(clazz);
            result = (Serializable)portalCache.get(primaryKey);
            if (result == null) {
                result = "";
            }
            if (localCache != null) {
                localCache.put(localCacheKey, result);
            }
        }
        return this._toEntityModel((Serializable)result);
    }

    public void init() {
    }

    public void invalidate() {
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable loadResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey, SessionFactory sessionFactory) {
        if (!(this._valueObjectEntityCacheEnabled && entityCacheEnabled && CacheRegistryUtil.isActive())) {
            Session session = null;
            try {
                session = sessionFactory.openSession();
                Serializable serializable = (Serializable)session.load(clazz, primaryKey);
                return serializable;
            }
            finally {
                sessionFactory.closeSession(session);
            }
        }
        Object result = null;
        Map localCache = null;
        LocalCacheKey localCacheKey = null;
        if (this._isLocalCacheEnabled()) {
            localCache = (Map)this._localCache.get();
            localCacheKey = new LocalCacheKey(clazz.getName(), primaryKey);
            result = (Serializable)localCache.get(localCacheKey);
        }
        Serializable loadResult = null;
        if (result == null) {
            PortalCache<Serializable, Serializable> portalCache = this.getPortalCache(clazz);
            result = (Serializable)portalCache.get(primaryKey);
            if (result == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Load ", clazz, " ", primaryKey, " from session"}));
                }
                Session session = null;
                try {
                    session = sessionFactory.openSession();
                    loadResult = (Serializable)session.load(clazz, primaryKey);
                }
                finally {
                    if (loadResult == null) {
                        result = "";
                    } else {
                        result = ((BaseModel)loadResult).toCacheModel();
                        PortalCacheHelperUtil.putWithoutReplicator(portalCache, (Serializable)primaryKey, (Object)result);
                    }
                    sessionFactory.closeSession(session);
                }
            }
            if (localCache != null) {
                localCache.put(localCacheKey, result);
            }
        }
        if (loadResult != null) {
            return loadResult;
        }
        return this._toEntityModel((Serializable)result);
    }

    public void notifyPortalCacheAdded(String portalCacheName) {
    }

    public void notifyPortalCacheRemoved(String portalCacheName) {
        if (portalCacheName.startsWith(_GROUP_KEY_PREFIX)) {
            this._portalCaches.remove(portalCacheName.substring(_GROUP_KEY_PREFIX.length()));
        }
    }

    public void putResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey, Serializable result) {
        this.putResult(entityCacheEnabled, clazz, primaryKey, result, true);
    }

    public void putResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey, Serializable result, boolean quiet) {
        if (!(this._valueObjectEntityCacheEnabled && entityCacheEnabled && CacheRegistryUtil.isActive() && result != null)) {
            return;
        }
        result = ((BaseModel)result).toCacheModel();
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            LocalCacheKey localCacheKey = new LocalCacheKey(clazz.getName(), primaryKey);
            localCache.put(localCacheKey, result);
        }
        PortalCache<Serializable, Serializable> portalCache = this.getPortalCache(clazz);
        if (quiet) {
            PortalCacheHelperUtil.putWithoutReplicator(portalCache, (Serializable)primaryKey, (Object)result);
        } else {
            portalCache.put(primaryKey, (Object)result);
        }
    }

    public void removeCache(String className) {
        this._portalCaches.remove(className);
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        this._multiVMPool.removePortalCache(groupKey);
    }

    public void removeResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey) {
        if (!(this._valueObjectEntityCacheEnabled && entityCacheEnabled && CacheRegistryUtil.isActive())) {
            return;
        }
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            LocalCacheKey localCacheKey = new LocalCacheKey(clazz.getName(), primaryKey);
            localCache.remove(localCacheKey);
        }
        PortalCache<Serializable, Serializable> portalCache = this.getPortalCache(clazz);
        portalCache.remove(primaryKey);
    }

    @Activate
    @Modified
    protected void activate() {
        this._valueObjectEntityBlockingCacheEnabled = GetterUtil.getBoolean((String)this._props.get("value.object.entity.blocking.cache"));
        this._valueObjectEntityCacheEnabled = GetterUtil.getBoolean((String)this._props.get("value.object.entity.cache.enabled"));
        this._valueObjectMVCCEntityCacheEnabled = GetterUtil.getBoolean((String)this._props.get("value.object.mvcc.entity.cache.enabled"));
        int localCacheMaxSize = GetterUtil.getInteger((String)this._props.get("value.object.entity.thread.local.cache.max.size"));
        this._localCache = localCacheMaxSize > 0 ? new CentralizedThreadLocal(EntityCacheImpl.class + "._localCache", () -> new LRUMap(localCacheMaxSize)) : null;
        PortalCacheManager portalCacheManager = this._multiVMPool.getPortalCacheManager();
        portalCacheManager.registerPortalCacheManagerListener((PortalCacheManagerListener)this);
    }

    @Reference(unbind="-")
    protected void setMultiVMPool(MultiVMPool multiVMPool) {
        this._multiVMPool = multiVMPool;
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._props = props;
    }

    private boolean _isLocalCacheEnabled() {
        if (this._localCache == null) {
            return false;
        }
        return ThreadLocalFilterThreadLocal.isFilterInvoked();
    }

    private Serializable _toEntityModel(Serializable result) {
        if (result == "") {
            return null;
        }
        CacheModel cacheModel = (CacheModel)result;
        BaseModel entityModel = (BaseModel)cacheModel.toEntityModel();
        entityModel.setCachedModel(true);
        return entityModel;
    }

    private static class LocalCacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _className;
        private final Serializable _primaryKey;

        public LocalCacheKey(String className, Serializable primaryKey) {
            this._className = className;
            this._primaryKey = primaryKey;
        }

        public boolean equals(Object obj) {
            LocalCacheKey localCacheKey = (LocalCacheKey)obj;
            return localCacheKey._className.equals(this._className) && localCacheKey._primaryKey.equals(this._primaryKey);
        }

        public int hashCode() {
            return this._className.hashCode() * 11 + this._primaryKey.hashCode();
        }
    }
}

