/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal.configurator;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.cache.ehcache.internal.configurator.BaseEhcachePortalCacheManagerConfigurator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={MultiVMEhcachePortalCacheManagerConfigurator.class})
public class MultiVMEhcachePortalCacheManagerConfigurator
extends BaseEhcachePortalCacheManagerConfigurator {
    protected boolean clusterEnabled;
    private String _defaultReplicatorPropertiesString;
    @Reference
    private Props _props;
    private Properties _replicatorProperties;

    @Activate
    protected void activate() {
        this.clusterEnabled = GetterUtil.getBoolean((String)this._props.get("cluster.link.enabled"));
        this._defaultReplicatorPropertiesString = this._getPortalPropertiesString("ehcache.replicator.properties.default");
        this._replicatorProperties = this._props.getProperties("ehcache.replicator.properties.", true);
    }

    @Override
    protected boolean isRequireSerialization(CacheConfiguration cacheConfiguration) {
        if (this.clusterEnabled) {
            return true;
        }
        return super.isRequireSerialization(cacheConfiguration);
    }

    @Override
    protected void manageConfiguration(Configuration configuration, PortalCacheManagerConfiguration portalCacheManagerConfiguration) {
        if (!this.clusterEnabled) {
            return;
        }
        Map<String, ObjectValuePair<Properties, Properties>> mergedPropertiesMap = this._getMergedPropertiesMap();
        for (Map.Entry<String, ObjectValuePair<Properties, Properties>> entry : mergedPropertiesMap.entrySet()) {
            ObjectValuePair<Properties, Properties> propertiesPair = entry.getValue();
            if (propertiesPair.getValue() == null) continue;
            PortalCacheConfiguration portalCacheConfiguration = portalCacheManagerConfiguration.getPortalCacheConfiguration(entry.getKey());
            Set portalCacheListenerPropertiesSet = portalCacheConfiguration.getPortalCacheListenerPropertiesSet();
            Iterator iterator = portalCacheListenerPropertiesSet.iterator();
            while (iterator.hasNext()) {
                Properties properties = (Properties)iterator.next();
                if (!((Boolean)properties.get("replicator")).booleanValue()) continue;
                iterator.remove();
            }
            portalCacheListenerPropertiesSet.add(propertiesPair.getValue());
        }
    }

    @Override
    protected PortalCacheConfiguration parseCacheListenerConfigurations(CacheConfiguration cacheConfiguration, ClassLoader classLoader, boolean usingDefault) {
        PortalCacheConfiguration portalCacheConfiguration = super.parseCacheListenerConfigurations(cacheConfiguration, classLoader, usingDefault);
        if (!this.clusterEnabled) {
            return portalCacheConfiguration;
        }
        String cacheName = cacheConfiguration.getName();
        String replicatorPropertiesString = (String)this._replicatorProperties.remove(cacheName);
        if (Validator.isNull((String)replicatorPropertiesString)) {
            replicatorPropertiesString = this._defaultReplicatorPropertiesString;
        }
        Properties replicatorProperties = this.parseProperties(replicatorPropertiesString, ",");
        replicatorProperties.put("replicator", (Object)true);
        Set portalCacheListenerPropertiesSet = portalCacheConfiguration.getPortalCacheListenerPropertiesSet();
        portalCacheListenerPropertiesSet.add(replicatorProperties);
        return portalCacheConfiguration;
    }

    private Map<String, ObjectValuePair<Properties, Properties>> _getMergedPropertiesMap() {
        HashMap<String, ObjectValuePair<Properties, Properties>> mergedPropertiesMap = new HashMap<String, ObjectValuePair<Properties, Properties>>();
        for (String portalCacheName : this._replicatorProperties.stringPropertyNames()) {
            Properties replicatorProperties = this.parseProperties(this._replicatorProperties.getProperty(portalCacheName), ",");
            replicatorProperties.put("replicator", (Object)true);
            ObjectValuePair objectValuePair = (ObjectValuePair)mergedPropertiesMap.get(portalCacheName);
            if (objectValuePair == null) {
                mergedPropertiesMap.put(portalCacheName, (ObjectValuePair<Properties, Properties>)new ObjectValuePair(null, (Object)replicatorProperties));
                continue;
            }
            objectValuePair.setValue((Object)replicatorProperties);
        }
        return mergedPropertiesMap;
    }

    private String _getPortalPropertiesString(String portalPropertyKey) {
        String[] array = this._props.getArray(portalPropertyKey);
        if (array.length == 0) {
            return null;
        }
        if (array.length == 1) {
            return array[0];
        }
        StringBundler sb = new StringBundler(array.length * 2);
        for (String value : array) {
            sb.append(value);
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }
}

