/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.cache.AggregatedPortalCacheManagerListener;
import com.liferay.portal.cache.LowLevelCache;
import com.liferay.portal.cache.MVCCPortalCache;
import com.liferay.portal.cache.PortalCacheListenerFactory;
import com.liferay.portal.cache.PortalCacheManagerListenerFactory;
import com.liferay.portal.cache.TransactionalPortalCache;
import com.liferay.portal.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.cache.ehcache.internal.BaseEhcachePortalCache;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCache;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCacheConfiguration;
import com.liferay.portal.cache.ehcache.internal.EhcacheUnwrapUtil;
import com.liferay.portal.cache.ehcache.internal.ShardedEhcachePortalCache;
import com.liferay.portal.cache.ehcache.internal.configurator.BaseEhcachePortalCacheManagerConfigurator;
import com.liferay.portal.cache.ehcache.internal.event.ConfigurableEhcachePortalCacheListener;
import com.liferay.portal.cache.ehcache.internal.event.PortalCacheManagerEventListener;
import com.liferay.portal.cache.ehcache.internal.management.ManagementService;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServer;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class EhcachePortalCacheManager<K extends Serializable, V>
implements PortalCacheManager<K, V> {
    protected BaseEhcachePortalCacheManagerConfigurator baseEhcachePortalCacheManagerConfigurator;
    protected BundleContext bundleContext;
    protected PortalCacheListenerFactory portalCacheListenerFactory;
    protected PortalCacheManagerListenerFactory<PortalCacheManager<K, V>> portalCacheManagerListenerFactory;
    protected volatile Props props;
    private static final Log _log = LogFactoryUtil.getLog(EhcachePortalCacheManager.class);
    private final AggregatedPortalCacheManagerListener _aggregatedPortalCacheManagerListener = new AggregatedPortalCacheManagerListener();
    private CacheManager _cacheManager;
    private String _configFile;
    private ServiceTracker<?, ?> _configuratorSettingsServiceTracker;
    private String _defaultConfigFile;
    private ServiceTracker<MBeanServer, ManagementService> _mBeanServerServiceTracker;
    private PortalCacheManagerConfiguration _portalCacheManagerConfiguration;
    private String _portalCacheManagerName;
    private final ConcurrentMap<String, PortalCache<K, V>> _portalCaches = new ConcurrentHashMap<String, PortalCache<K, V>>();
    private boolean _transactionalPortalCacheEnabled;
    private String[] _transactionalPortalCacheNames = StringPool.EMPTY_ARRAY;
    private boolean _usingDefault;

    public void clearAll() throws PortalCacheException {
        for (String cacheName : this._cacheManager.getCacheNames()) {
            Cache cache = this._cacheManager.getCache(cacheName);
            if (cache == null) continue;
            cache.removeAll();
        }
    }

    public void destroy() {
        this._portalCaches.clear();
        this._cacheManager.shutdown();
        if (this._configuratorSettingsServiceTracker != null) {
            this._configuratorSettingsServiceTracker.close();
            this._configuratorSettingsServiceTracker = null;
        }
        if (this._mBeanServerServiceTracker != null) {
            this._mBeanServerServiceTracker.close();
        }
    }

    public PortalCache<K, V> fetchPortalCache(String portalCacheName) {
        return (PortalCache)this._portalCaches.get(portalCacheName);
    }

    public CacheManager getEhcacheManager() {
        return this._cacheManager;
    }

    public PortalCache<K, V> getPortalCache(String portalCacheName) throws PortalCacheException {
        return this.getPortalCache(portalCacheName, false);
    }

    public PortalCache<K, V> getPortalCache(String portalCacheName, boolean mvcc) throws PortalCacheException {
        return this.getPortalCache(portalCacheName, mvcc, false);
    }

    public PortalCache<K, V> getPortalCache(String portalCacheName, boolean mvcc, boolean sharded) throws PortalCacheException {
        return this._portalCaches.compute(portalCacheName, (key, value) -> {
            if (value != null) {
                this._verifyMVCCPortalCache((PortalCache<K, V>)value, mvcc);
                this._verifyShardedPortalCache((PortalCache<K, V>)value, sharded);
                return value;
            }
            PortalCacheConfiguration portalCacheConfiguration = this._portalCacheManagerConfiguration.getPortalCacheConfiguration(portalCacheName);
            EhcachePortalCacheConfiguration ehcachePortalCacheConfiguration = (EhcachePortalCacheConfiguration)portalCacheConfiguration;
            value = sharded ? new ShardedEhcachePortalCache(this, ehcachePortalCacheConfiguration) : new EhcachePortalCache(this, ehcachePortalCacheConfiguration);
            this._initPortalCacheListeners((PortalCache<K, V>)value, portalCacheConfiguration);
            if (mvcc) {
                value = new MVCCPortalCache((LowLevelCache)value);
            }
            if (this._transactionalPortalCacheEnabled) {
                for (String namePattern : this._transactionalPortalCacheNames) {
                    if (!StringUtil.wildcardMatches((String)portalCacheName, (String)namePattern, (char)'?', (char)'*', (char)'%', (boolean)true)) continue;
                    value = new TransactionalPortalCache(value, mvcc);
                }
            }
            return value;
        });
    }

    public Set<PortalCacheManagerListener> getPortalCacheManagerListeners() {
        return this._aggregatedPortalCacheManagerListener.getPortalCacheManagerListeners();
    }

    public String getPortalCacheManagerName() {
        return this._portalCacheManagerName;
    }

    public void reconfigurePortalCaches(URL configurationURL, ClassLoader classLoader) {
        ObjectValuePair<Configuration, PortalCacheManagerConfiguration> configurationObjectValuePair = this.baseEhcachePortalCacheManagerConfigurator.getConfigurationObjectValuePair(this._portalCacheManagerName, configurationURL, classLoader, this._usingDefault);
        this._reconfigEhcache((Configuration)configurationObjectValuePair.getKey());
        this._reconfigPortalCache((PortalCacheManagerConfiguration)configurationObjectValuePair.getValue());
    }

    public boolean registerPortalCacheManagerListener(PortalCacheManagerListener portalCacheManagerListener) {
        return this._aggregatedPortalCacheManagerListener.addPortalCacheListener(portalCacheManagerListener);
    }

    public void removePortalCache(String portalCacheName) {
        PortalCache portalCache = (PortalCache)this._portalCaches.remove(portalCacheName);
        if (portalCache == null) {
            return;
        }
        BaseEhcachePortalCache baseEhcachePortalCache = EhcacheUnwrapUtil.getWrappedPortalCache(portalCache);
        if (baseEhcachePortalCache != null) {
            baseEhcachePortalCache.dispose();
        } else {
            _log.error((Object)("Unable to dispose cache with name " + portalCache.getPortalCacheName()));
        }
    }

    public void removePortalCaches(long companyId) {
        for (PortalCache portalCache : this._portalCaches.values()) {
            if (!portalCache.isSharded()) continue;
            ShardedEhcachePortalCache shardedEhcachePortalCache = (ShardedEhcachePortalCache)EhcacheUnwrapUtil.getWrappedPortalCache(portalCache);
            shardedEhcachePortalCache.removeEhcache(companyId);
        }
    }

    public void setConfigFile(String configFile) {
        this._configFile = configFile;
    }

    public void setDefaultConfigFile(String defaultConfigFile) {
        this._defaultConfigFile = defaultConfigFile;
    }

    public void setPortalCacheManagerName(String portalCacheManagerName) {
        this._portalCacheManagerName = portalCacheManagerName;
    }

    public boolean unregisterPortalCacheManagerListener(PortalCacheManagerListener portalCacheManagerListener) {
        return this._aggregatedPortalCacheManagerListener.removePortalCacheListener(portalCacheManagerListener);
    }

    public void unregisterPortalCacheManagerListeners() {
        this._aggregatedPortalCacheManagerListener.clearAll();
    }

    protected void initialize() {
        ClassLoader classLoader;
        URL configFileURL;
        if (this._portalCacheManagerConfiguration != null) {
            return;
        }
        if (Validator.isNull((String)this._portalCacheManagerName)) {
            throw new IllegalArgumentException("Portal cache manager name is not specified");
        }
        this._transactionalPortalCacheEnabled = GetterUtil.getBoolean((String)this.props.get("transactional.cache.enable"));
        this._transactionalPortalCacheNames = GetterUtil.getStringValues((String[])this.props.getArray("transactional.cache.names"));
        if (Validator.isNull((String)this._configFile)) {
            this._configFile = this._defaultConfigFile;
        }
        if ((configFileURL = (classLoader = BaseEhcachePortalCacheManagerConfigurator.class.getClassLoader()).getResource(this._configFile)) == null) {
            classLoader = PortalClassLoaderUtil.getClassLoader();
            configFileURL = classLoader.getResource(this._configFile);
        }
        this._usingDefault = this._configFile.equals(this._defaultConfigFile);
        ObjectValuePair<Configuration, PortalCacheManagerConfiguration> configurationObjectValuePair = this.baseEhcachePortalCacheManagerConfigurator.getConfigurationObjectValuePair(this._portalCacheManagerName, configFileURL, classLoader, this._usingDefault);
        this._cacheManager = new CacheManager((Configuration)configurationObjectValuePair.getKey());
        this._portalCacheManagerConfiguration = (PortalCacheManagerConfiguration)configurationObjectValuePair.getValue();
        CacheManagerEventListenerRegistry cacheManagerEventListenerRegistry = this._cacheManager.getCacheManagerEventListenerRegistry();
        cacheManagerEventListenerRegistry.registerListener((CacheManagerEventListener)new PortalCacheManagerEventListener((PortalCacheManagerListener)this._aggregatedPortalCacheManagerListener));
        if (!GetterUtil.getBoolean((String)this.props.get("ehcache.portal.cache.manager.jmx.enabled"))) {
            return;
        }
        this._mBeanServerServiceTracker = new ServiceTracker<MBeanServer, ManagementService>(this.bundleContext, MBeanServer.class, null){

            public ManagementService addingService(ServiceReference<MBeanServer> serviceReference) {
                MBeanServer mBeanServer = (MBeanServer)EhcachePortalCacheManager.this.bundleContext.getService(serviceReference);
                ManagementService managementService = new ManagementService(EhcachePortalCacheManager.this._cacheManager, mBeanServer);
                managementService.init();
                return managementService;
            }

            public void removedService(ServiceReference<MBeanServer> serviceReference, ManagementService managementService) {
                managementService.dispose();
                EhcachePortalCacheManager.this.bundleContext.ungetService(serviceReference);
            }
        };
        this._mBeanServerServiceTracker.open();
        for (Properties properties : this._portalCacheManagerConfiguration.getPortalCacheManagerListenerPropertiesSet()) {
            PortalCacheManagerListener portalCacheManagerListener = this.portalCacheManagerListenerFactory.create((PortalCacheManager)this, properties);
            if (portalCacheManagerListener == null) continue;
            this.registerPortalCacheManagerListener(portalCacheManagerListener);
        }
    }

    private void _initPortalCacheListeners(PortalCache<K, V> portalCache, PortalCacheConfiguration portalCacheConfiguration) {
        if (portalCacheConfiguration == null) {
            return;
        }
        for (Properties properties : portalCacheConfiguration.getPortalCacheListenerPropertiesSet()) {
            PortalCacheListener portalCacheListener = this.portalCacheListenerFactory.create(properties);
            if (portalCacheListener == null) continue;
            PortalCacheListenerScope portalCacheListenerScope = (PortalCacheListenerScope)properties.remove("PORTAL_CACHE_LISTENER_PROPERTIES_KEY_SCOPE");
            if (portalCacheListenerScope == null) {
                portalCacheListenerScope = PortalCacheListenerScope.ALL;
            }
            portalCache.registerPortalCacheListener(portalCacheListener, portalCacheListenerScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _reconfigEhcache(Configuration configuration) {
        Map cacheConfigurations = configuration.getCacheConfigurations();
        for (CacheConfiguration cacheConfiguration : cacheConfigurations.values()) {
            String portalCacheName = cacheConfiguration.getName();
            CacheManager cacheManager = this._cacheManager;
            synchronized (cacheManager) {
                if (this._cacheManager.cacheExists(portalCacheName)) {
                    PortalCache<K, V> portalCache;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Overriding existing cache " + portalCacheName));
                    }
                    if ((portalCache = this.fetchPortalCache(portalCacheName)) != null) {
                        BaseEhcachePortalCache<K, V> baseEhcachePortalCache = EhcacheUnwrapUtil.getWrappedPortalCache(portalCache);
                        if (baseEhcachePortalCache != null) {
                            baseEhcachePortalCache.resetEhcache();
                        } else {
                            _log.error((Object)("Unable to reconfigure cache with name " + portalCacheName));
                        }
                    }
                    this._cacheManager.removeCache(portalCacheName);
                }
                this._cacheManager.addCache(new Cache(cacheConfiguration));
            }
        }
    }

    private void _reconfigPortalCache(PortalCacheManagerConfiguration portalCacheManagerConfiguration) {
        for (String portalCacheName : portalCacheManagerConfiguration.getPortalCacheNames()) {
            PortalCacheConfiguration portalCacheConfiguration = portalCacheManagerConfiguration.getPortalCacheConfiguration(portalCacheName);
            this._portalCacheManagerConfiguration.putPortalCacheConfiguration(portalCacheName, portalCacheConfiguration);
            PortalCache portalCache = (PortalCache)this._portalCaches.get(portalCacheName);
            if (portalCache == null) continue;
            BaseEhcachePortalCache baseEhcachePortalCache = EhcacheUnwrapUtil.getWrappedPortalCache(portalCache);
            Map portalCacheListeners = baseEhcachePortalCache.getPortalCacheListeners();
            for (PortalCacheListener portalCacheListener : portalCacheListeners.keySet()) {
                if (!(portalCacheListener instanceof ConfigurableEhcachePortalCacheListener)) continue;
                portalCache.unregisterPortalCacheListener(portalCacheListener);
            }
            this._initPortalCacheListeners(portalCache, portalCacheConfiguration);
        }
    }

    private void _verifyMVCCPortalCache(PortalCache<K, V> portalCache, boolean mvcc) {
        if (mvcc == portalCache.isMVCC()) {
            return;
        }
        StringBundler sb = new StringBundler(9);
        sb.append("Unable to get portal cache ");
        sb.append(portalCache.getPortalCacheName());
        sb.append(" from portal cache manager ");
        sb.append(this._portalCacheManagerName);
        sb.append(" as a ");
        if (mvcc) {
            sb.append("MVCC ");
        } else {
            sb.append("non-MVCC ");
        }
        sb.append("portal cache, because a ");
        if (portalCache.isMVCC()) {
            sb.append("MVCC ");
        } else {
            sb.append("non-MVCC ");
        }
        sb.append("portal cache with same name exists.");
        throw new IllegalStateException(sb.toString());
    }

    private void _verifyShardedPortalCache(PortalCache<K, V> portalCache, boolean sharded) {
        if (sharded == portalCache.isSharded()) {
            return;
        }
        StringBundler sb = new StringBundler(9);
        sb.append("Unable to get portal cache ");
        sb.append(portalCache.getPortalCacheName());
        sb.append(" from portal cache manager ");
        sb.append(this._portalCacheManagerName);
        sb.append(" as a ");
        if (sharded) {
            sb.append("sharded ");
        } else {
            sb.append("nonsharded ");
        }
        sb.append("portal cache, because a ");
        if (portalCache.isSharded()) {
            sb.append("sharded ");
        } else {
            sb.append("nonsharded ");
        }
        sb.append("portal cache with same name exists.");
        throw new IllegalStateException(sb.toString());
    }
}

