/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal.event;

import com.liferay.portal.cache.ehcache.internal.EhcacheUnwrapUtil;
import com.liferay.portal.cache.ehcache.internal.event.ConfigurableEhcachePortalCacheListener;
import com.liferay.portal.cache.io.SerializableObjectWrapper;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import java.io.Serializable;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class EhcachePortalCacheListenerAdapter<K extends Serializable, V>
implements ConfigurableEhcachePortalCacheListener,
PortalCacheListener<K, V> {
    protected final CacheEventListener cacheEventListener;

    public EhcachePortalCacheListenerAdapter(CacheEventListener cacheEventListener) {
        this.cacheEventListener = cacheEventListener;
    }

    public void dispose() {
        this.cacheEventListener.dispose();
    }

    public void notifyEntryEvicted(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        Element element = this.createElement(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        this.cacheEventListener.notifyElementEvicted(EhcacheUnwrapUtil.getEhcache(portalCache), element);
    }

    public void notifyEntryExpired(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        Element element = this.createElement(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        this.cacheEventListener.notifyElementExpired(EhcacheUnwrapUtil.getEhcache(portalCache), element);
    }

    public void notifyEntryPut(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        Element element = this.createElement(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        this.cacheEventListener.notifyElementPut(EhcacheUnwrapUtil.getEhcache(portalCache), element);
    }

    public void notifyEntryRemoved(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        Element element = this.createElement(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        this.cacheEventListener.notifyElementRemoved(EhcacheUnwrapUtil.getEhcache(portalCache), element);
    }

    public void notifyEntryUpdated(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        Element element = this.createElement(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        this.cacheEventListener.notifyElementUpdated(EhcacheUnwrapUtil.getEhcache(portalCache), element);
    }

    public void notifyRemoveAll(PortalCache<K, V> portalCache) throws PortalCacheException {
        this.cacheEventListener.notifyRemoveAll(EhcacheUnwrapUtil.getEhcache(portalCache));
    }

    protected Element createElement(K key, V value) {
        Object objectValue = value;
        if (value instanceof Serializable) {
            objectValue = new SerializableObjectWrapper((Serializable)value);
        }
        return new Element((Object)new SerializableObjectWrapper(key), objectValue);
    }
}

