/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal.management;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerRegistry;
import net.sf.ehcache.management.Cache;
import net.sf.ehcache.management.CacheConfiguration;
import net.sf.ehcache.management.CacheManager;
import net.sf.ehcache.management.CacheStatistics;
import net.sf.ehcache.management.ManagedCacheManagerPeerProvider;

public class ManagementService
implements CacheManagerEventListener {
    private static final Log _log = LogFactoryUtil.getLog(ManagementService.class);
    private final net.sf.ehcache.CacheManager _cacheManager;
    private final MBeanServer _mBeanServer;
    private Status _status;

    public ManagementService(net.sf.ehcache.CacheManager cacheManager, MBeanServer mBeanServer) {
        this._cacheManager = cacheManager;
        this._mBeanServer = mBeanServer;
        this._status = Status.STATUS_UNINITIALISED;
    }

    public void dispose() {
        this._unregisterMBeans(this._mBeanServer.queryNames(ManagementService._getObjectName("CacheManager", null, this._cacheManager.getName()), null));
        this._unregisterMBeans(this._mBeanServer.queryNames(ManagementService._getObjectName("*", this._cacheManager.getName(), "*"), null));
        this._status = Status.STATUS_SHUTDOWN;
    }

    public Status getStatus() {
        return this._status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        try {
            this._mBeanServer.registerMBean(new CacheManager(this._cacheManager), ManagementService._getObjectName("CacheManager", null, this._cacheManager.getName()));
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        Map cacheManagerPeerProviders = this._cacheManager.getCacheManagerPeerProviders();
        for (CacheManagerPeerProvider cacheManagerPeerProvider : cacheManagerPeerProviders.values()) {
            if (!(cacheManagerPeerProvider instanceof ManagedCacheManagerPeerProvider)) continue;
            ManagedCacheManagerPeerProvider managedCacheManagerPeerProvider = (ManagedCacheManagerPeerProvider)cacheManagerPeerProvider;
            managedCacheManagerPeerProvider.register(this._mBeanServer);
        }
        CacheManagerEventListenerRegistry cacheManagerEventListenerRegistry = this._cacheManager.getCacheManagerEventListenerRegistry();
        cacheManagerEventListenerRegistry.registerListener((CacheManagerEventListener)this);
        net.sf.ehcache.CacheManager cacheManager = this._cacheManager;
        synchronized (cacheManager) {
            for (String cacheName : this._cacheManager.getCacheNames()) {
                this._registerCache(cacheName);
            }
        }
        this._status = Status.STATUS_ALIVE;
    }

    public void notifyCacheAdded(String cacheName) {
        this._registerCache(cacheName);
    }

    public void notifyCacheRemoved(String cacheName) {
        this._unregisterMBeans(this._mBeanServer.queryNames(ManagementService._getObjectName("*", this._cacheManager.getName(), cacheName), null));
    }

    private static ObjectName _getObjectName(String type, String cacheManagerName, String name) {
        StringBundler sb = new StringBundler(6);
        sb.append("net.sf.ehcache:type=");
        sb.append(type);
        if (cacheManagerName != null) {
            sb.append(",CacheManager=");
            sb.append(cacheManagerName);
        }
        sb.append(",name=");
        if (name != null) {
            name = StringUtil.replace((String)name, (char[])new char[]{',', ':', '=', '\n'}, (char[])new char[]{'.', '.', '.', '.'});
            sb.append(name);
        }
        try {
            return new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException mone) {
            return (ObjectName)ReflectionUtil.throwException((Throwable)mone);
        }
    }

    private void _registerCache(String cacheName) {
        block4: {
            Ehcache ehcache = this._cacheManager.getEhcache(cacheName);
            Cache cacheMBean = new Cache(ehcache);
            try {
                this._mBeanServer.registerMBean(cacheMBean, ManagementService._getObjectName("Cache", this._cacheManager.getName(), cacheMBean.getName()));
                CacheStatistics cacheStatisticsMBean = new CacheStatistics(ehcache);
                this._mBeanServer.registerMBean(cacheStatisticsMBean, ManagementService._getObjectName("CacheStatistics", this._cacheManager.getName(), cacheStatisticsMBean.getAssociatedCacheName()));
                CacheConfiguration cacheConfigurationMBean = new CacheConfiguration(ehcache);
                this._mBeanServer.registerMBean(cacheConfigurationMBean, ManagementService._getObjectName("CacheConfiguration", this._cacheManager.getName(), cacheConfigurationMBean.getName()));
            }
            catch (InstanceAlreadyExistsException iaee) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)iaee, (Throwable)iaee);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    private void _unregisterMBeans(Set<ObjectName> objectNames) {
        for (ObjectName objectName : objectNames) {
            try {
                if (!this._mBeanServer.isRegistered(objectName)) continue;
                this._mBeanServer.unregisterMBean(objectName);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }
}

