/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal.configurator;

import com.liferay.portal.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCacheConfiguration;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.event.NotificationScope;

public abstract class BaseEhcachePortalCacheManagerConfigurator {
    protected Props props;
    private static final Map<NotificationScope, PortalCacheListenerScope> _portalCacheListenerScopes = new EnumMap<NotificationScope, PortalCacheListenerScope>(NotificationScope.class){
        {
            this.put(NotificationScope.ALL, PortalCacheListenerScope.ALL);
            this.put(NotificationScope.LOCAL, PortalCacheListenerScope.LOCAL);
            this.put(NotificationScope.REMOTE, PortalCacheListenerScope.REMOTE);
        }
    };

    public ObjectValuePair<Configuration, PortalCacheManagerConfiguration> getConfigurationObjectValuePair(String portalCacheManagerName, URL configurationURL, boolean usingDefault) {
        if (configurationURL == null) {
            throw new NullPointerException("Configuration path is null");
        }
        Configuration configuration = ConfigurationFactory.parseConfiguration((URL)configurationURL);
        configuration.setName(portalCacheManagerName);
        PortalCacheManagerConfiguration portalCacheManagerConfiguration = this.parseListenerConfigurations(configuration, usingDefault);
        this.clearListenerConfigrations(configuration);
        this.manageConfiguration(configuration, portalCacheManagerConfiguration);
        return new ObjectValuePair((Object)configuration, (Object)portalCacheManagerConfiguration);
    }

    protected void clearListenerConfigrations(CacheConfiguration cacheConfiguration) {
        if (cacheConfiguration == null) {
            return;
        }
        cacheConfiguration.bootstrapCacheLoaderFactory(null);
        List factoryConfigurations = cacheConfiguration.getCacheEventListenerConfigurations();
        factoryConfigurations.clear();
    }

    protected void clearListenerConfigrations(Configuration configuration) {
        List listenerFactoryConfigurations = configuration.getCacheManagerPeerListenerFactoryConfigurations();
        listenerFactoryConfigurations.clear();
        List providerFactoryConfigurations = configuration.getCacheManagerPeerProviderFactoryConfiguration();
        providerFactoryConfigurations.clear();
        FactoryConfiguration factoryConfiguration = configuration.getCacheManagerEventListenerFactoryConfiguration();
        if (factoryConfiguration != null) {
            factoryConfiguration.setClass(null);
        }
        this.clearListenerConfigrations(configuration.getDefaultCacheConfiguration());
        Map cacheConfigurations = configuration.getCacheConfigurations();
        for (CacheConfiguration cacheConfiguration : cacheConfigurations.values()) {
            this.clearListenerConfigrations(cacheConfiguration);
        }
    }

    protected boolean isRequireSerialization(CacheConfiguration cacheConfiguration) {
        PersistenceConfiguration.Strategy strategy;
        if (cacheConfiguration.isOverflowToDisk() || cacheConfiguration.isOverflowToOffHeap() || cacheConfiguration.isDiskPersistent()) {
            return true;
        }
        PersistenceConfiguration persistenceConfiguration = cacheConfiguration.getPersistenceConfiguration();
        return persistenceConfiguration != null && !(strategy = persistenceConfiguration.getStrategy()).equals((Object)PersistenceConfiguration.Strategy.NONE);
    }

    protected void manageConfiguration(Configuration configuration, PortalCacheManagerConfiguration portalCacheManagerConfiguration) {
    }

    protected Set<Properties> parseCacheEventListenerConfigurations(List<CacheConfiguration.CacheEventListenerFactoryConfiguration> cacheEventListenerConfigurations, boolean usingDefault) {
        if (usingDefault) {
            return Collections.emptySet();
        }
        HashSet<Properties> portalCacheListenerPropertiesSet = new HashSet<Properties>();
        for (CacheConfiguration.CacheEventListenerFactoryConfiguration cacheEventListenerFactoryConfiguration : cacheEventListenerConfigurations) {
            Properties properties = this.parseProperties(cacheEventListenerFactoryConfiguration.getProperties(), cacheEventListenerFactoryConfiguration.getPropertySeparator());
            String factoryClassName = cacheEventListenerFactoryConfiguration.getFullyQualifiedClassPath();
            properties.put("CACHE_LISTENER_PROPERTIES_KEY_FACTORY_CLASS_NAME", factoryClassName);
            PortalCacheListenerScope portalCacheListenerScope = _portalCacheListenerScopes.get(cacheEventListenerFactoryConfiguration.getListenFor());
            properties.put("PORTAL_CACHE_LISTENER_PROPERTIES_KEY_SCOPE", portalCacheListenerScope);
            portalCacheListenerPropertiesSet.add(properties);
        }
        return portalCacheListenerPropertiesSet;
    }

    protected PortalCacheConfiguration parseCacheListenerConfigurations(CacheConfiguration cacheConfiguration, boolean usingDefault) {
        Set<Properties> portalCacheListenerPropertiesSet = this.parseCacheEventListenerConfigurations(cacheConfiguration.getCacheEventListenerConfigurations(), usingDefault);
        boolean requireSerialization = this.isRequireSerialization(cacheConfiguration);
        return new EhcachePortalCacheConfiguration(cacheConfiguration.getName(), portalCacheListenerPropertiesSet, null, requireSerialization);
    }

    protected Set<Properties> parseCacheManagerEventListenerConfigurations(FactoryConfiguration<?> factoryConfiguration) {
        if (factoryConfiguration == null) {
            return Collections.emptySet();
        }
        Properties properties = this.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
        properties.put("CACHE_MANAGER_LISTENER_PROPERTIES_KEY_FACTORY_CLASS_NAME", factoryConfiguration.getFullyQualifiedClassPath());
        return Collections.singleton(properties);
    }

    protected PortalCacheManagerConfiguration parseListenerConfigurations(Configuration configuration, boolean usingDefault) {
        Set<Properties> cacheManagerListenerPropertiesSet = this.parseCacheManagerEventListenerConfigurations(configuration.getCacheManagerEventListenerFactoryConfiguration());
        CacheConfiguration defaultCacheConfiguration = configuration.getDefaultCacheConfiguration();
        if (defaultCacheConfiguration == null) {
            defaultCacheConfiguration = new CacheConfiguration();
        }
        defaultCacheConfiguration.setName("default");
        PortalCacheConfiguration defaultPortalCacheConfiguration = this.parseCacheListenerConfigurations(defaultCacheConfiguration, usingDefault);
        HashSet<PortalCacheConfiguration> portalCacheConfigurations = new HashSet<PortalCacheConfiguration>();
        Map cacheConfigurations = configuration.getCacheConfigurations();
        for (Map.Entry entry : cacheConfigurations.entrySet()) {
            portalCacheConfigurations.add(this.parseCacheListenerConfigurations((CacheConfiguration)entry.getValue(), usingDefault));
        }
        return new PortalCacheManagerConfiguration(cacheManagerListenerPropertiesSet, defaultPortalCacheConfiguration, portalCacheConfigurations);
    }

    protected Properties parseProperties(String propertiesString, String propertySeparator) {
        Properties properties = new Properties();
        if (propertiesString == null) {
            return properties;
        }
        String propertyLines = propertiesString.trim();
        propertyLines = StringUtil.replace((String)propertyLines, (String)propertySeparator, (String)"\n");
        try {
            properties.load((Reader)new UnsyncStringReader(propertyLines));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return properties;
    }
}

