/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cache.BasePortalCacheManager;
import com.liferay.portal.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCache;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCacheConfiguration;
import com.liferay.portal.cache.ehcache.internal.SerializableEhcachePortalCache;
import com.liferay.portal.cache.ehcache.internal.configurator.BaseEhcachePortalCacheManagerConfigurator;
import com.liferay.portal.cache.ehcache.internal.event.PortalCacheManagerEventListener;
import com.liferay.portal.cache.ehcache.internal.management.ManagementService;
import com.liferay.portal.cache.ehcache.spi.EhcacheUnwrapUtil;
import com.liferay.portal.cache.ehcache.spi.event.ConfigurableEhcachePortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.cache.configurator.PortalCacheConfiguratorSettings;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import javax.management.MBeanServer;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerRegistry;
import net.sf.ehcache.util.FailSafeTimer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class EhcachePortalCacheManager<K extends Serializable, V>
extends BasePortalCacheManager<K, V> {
    protected BaseEhcachePortalCacheManagerConfigurator baseEhcachePortalCacheManagerConfigurator;
    protected BundleContext bundleContext;
    protected volatile Props props;
    private static final Log _log = LogFactoryUtil.getLog(EhcachePortalCacheManager.class);
    private CacheManager _cacheManager;
    private String _configFile;
    private ServiceTracker<?, ?> _configuratorSettingsServiceTracker;
    private String _defaultConfigFile;
    private ServiceTracker<MBeanServer, ManagementService> _mBeanServerServiceTracker;
    private PortalCacheManagerConfiguration _portalCacheManagerConfiguration;
    private boolean _usingDefault;

    public CacheManager getEhcacheManager() {
        return this._cacheManager;
    }

    public void reconfigurePortalCaches(URL configurationURL) {
        ObjectValuePair<Configuration, PortalCacheManagerConfiguration> configurationObjectValuePair = this.baseEhcachePortalCacheManagerConfigurator.getConfigurationObjectValuePair(this.getPortalCacheManagerName(), configurationURL, this._usingDefault);
        this.reconfigEhcache((Configuration)configurationObjectValuePair.getKey());
        this.reconfigPortalCache((PortalCacheManagerConfiguration)configurationObjectValuePair.getValue());
    }

    public void setConfigFile(String configFile) {
        this._configFile = configFile;
    }

    public void setDefaultConfigFile(String defaultConfigFile) {
        this._defaultConfigFile = defaultConfigFile;
    }

    protected Ehcache createEhcache(String portalCacheName, CacheConfiguration cacheConfiguration) {
        if (this._cacheManager.cacheExists(portalCacheName)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Overriding existing cache " + portalCacheName));
            }
            this._cacheManager.removeCache(portalCacheName);
        }
        Cache cache = new Cache(cacheConfiguration);
        this._cacheManager.addCache(cache);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortalCache<K, V> createPortalCache(PortalCacheConfiguration portalCacheConfiguration) {
        String portalCacheName = portalCacheConfiguration.getPortalCacheName();
        CacheManager cacheManager = this._cacheManager;
        synchronized (cacheManager) {
            if (!this._cacheManager.cacheExists(portalCacheName)) {
                this._cacheManager.addCache(portalCacheName);
            }
        }
        Cache cache = this._cacheManager.getCache(portalCacheName);
        EhcachePortalCacheConfiguration ehcachePortalCacheConfiguration = (EhcachePortalCacheConfiguration)portalCacheConfiguration;
        if (ehcachePortalCacheConfiguration.isRequireSerialization()) {
            return new SerializableEhcachePortalCache(this, (Ehcache)cache);
        }
        return new EhcachePortalCache(this, (Ehcache)cache);
    }

    protected void doClearAll() {
        for (String cacheName : this._cacheManager.getCacheNames()) {
            Cache cache = this._cacheManager.getCache(cacheName);
            if (cache == null) continue;
            cache.removeAll();
        }
    }

    protected void doDestroy() {
        this._cacheManager.shutdown();
        if (this._configuratorSettingsServiceTracker != null) {
            this._configuratorSettingsServiceTracker.close();
            this._configuratorSettingsServiceTracker = null;
        }
        if (this._mBeanServerServiceTracker != null) {
            this._mBeanServerServiceTracker.close();
        }
    }

    protected void doRemovePortalCache(String portalCacheName) {
        this._cacheManager.removeCache(portalCacheName);
    }

    protected PortalCacheManagerConfiguration getPortalCacheManagerConfiguration() {
        return this._portalCacheManagerConfiguration;
    }

    protected void initPortalCacheConfiguratorSettingsServiceTracker() {
        String filterString = StringBundler.concat((String[])new String[]{"(&(objectClass=", PortalCacheConfiguratorSettings.class.getName(), ")(", "portal.cache.manager.name", "=", this.getPortalCacheManagerName(), "))"});
        this._configuratorSettingsServiceTracker = ServiceTrackerFactory.open((BundleContext)this.bundleContext, (String)filterString, (ServiceTrackerCustomizer)new PortalCacheConfiguratorSettingsServiceTrackerCustomizer());
    }

    protected void initPortalCacheManager() {
        URL configFileURL;
        this.setBlockingPortalCacheAllowed(GetterUtil.getBoolean((String)this.props.get("ehcache.blocking.cache.allowed")));
        this.setTransactionalPortalCacheEnabled(GetterUtil.getBoolean((String)this.props.get("transactional.cache.enable")));
        this.setTransactionalPortalCacheNames(GetterUtil.getStringValues((String[])this.props.getArray("transactional.cache.names")));
        if (Validator.isNull((String)this._configFile)) {
            this._configFile = this._defaultConfigFile;
        }
        if ((configFileURL = BaseEhcachePortalCacheManagerConfigurator.class.getResource(this._configFile)) == null) {
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            configFileURL = classLoader.getResource(this._configFile);
        }
        this._usingDefault = this._configFile.equals(this._defaultConfigFile);
        ObjectValuePair<Configuration, PortalCacheManagerConfiguration> configurationObjectValuePair = this.baseEhcachePortalCacheManagerConfigurator.getConfigurationObjectValuePair(this.getPortalCacheManagerName(), configFileURL, this._usingDefault);
        this._cacheManager = new CacheManager((Configuration)configurationObjectValuePair.getKey());
        this._portalCacheManagerConfiguration = (PortalCacheManagerConfiguration)configurationObjectValuePair.getValue();
        FailSafeTimer failSafeTimer = this._cacheManager.getTimer();
        failSafeTimer.cancel();
        try {
            Field cacheManagerTimerField = ReflectionUtil.getDeclaredField(CacheManager.class, (String)"cacheManagerTimer");
            cacheManagerTimerField.set(this._cacheManager, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CacheManagerEventListenerRegistry cacheManagerEventListenerRegistry = this._cacheManager.getCacheManagerEventListenerRegistry();
        cacheManagerEventListenerRegistry.registerListener((CacheManagerEventListener)new PortalCacheManagerEventListener((PortalCacheManagerListener)this.aggregatedPortalCacheManagerListener));
        if (GetterUtil.getBoolean((String)this.props.get("ehcache.portal.cache.manager.jmx.enabled"))) {
            this._mBeanServerServiceTracker = new ServiceTracker<MBeanServer, ManagementService>(this.bundleContext, MBeanServer.class, null){

                public ManagementService addingService(ServiceReference<MBeanServer> serviceReference) {
                    MBeanServer mBeanServer = (MBeanServer)EhcachePortalCacheManager.this.bundleContext.getService(serviceReference);
                    ManagementService managementService = new ManagementService(EhcachePortalCacheManager.this._cacheManager, mBeanServer);
                    managementService.init();
                    return managementService;
                }

                public void removedService(ServiceReference<MBeanServer> serviceReference, ManagementService managementService) {
                    managementService.dispose();
                    EhcachePortalCacheManager.this.bundleContext.ungetService(serviceReference);
                }
            };
            this._mBeanServerServiceTracker.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconfigEhcache(Configuration configuration) {
        Map cacheConfigurations = configuration.getCacheConfigurations();
        for (CacheConfiguration cacheConfiguration : cacheConfigurations.values()) {
            String portalCacheName = cacheConfiguration.getName();
            CacheManager cacheManager = this._cacheManager;
            synchronized (cacheManager) {
                Ehcache ehcache = this.createEhcache(portalCacheName, cacheConfiguration);
                PortalCache portalCache = (PortalCache)this.portalCaches.get(portalCacheName);
                if (portalCache != null) {
                    EhcachePortalCache ehcachePortalCache = (EhcachePortalCache)EhcacheUnwrapUtil.getWrappedPortalCache((PortalCache)portalCache);
                    if (ehcachePortalCache != null) {
                        ehcachePortalCache.reconfigEhcache(ehcache);
                    } else {
                        _log.error((Object)("Unable to reconfigure cache with name " + portalCacheName));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean reconfigure(PortalCacheConfiguratorSettings portalCacheConfiguratorSettings) {
        String portalCacheConfigurationLocation = portalCacheConfiguratorSettings.getPortalCacheConfigrationLocation();
        if (Validator.isNull((String)portalCacheConfigurationLocation)) {
            return false;
        }
        ClassLoader classLoader = portalCacheConfiguratorSettings.getClassLoader();
        URL url = classLoader.getResource(portalCacheConfigurationLocation);
        if (url == null) {
            return false;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(AggregateClassLoader.getAggregateClassLoader((ClassLoader)PortalClassLoaderUtil.getClassLoader(), (ClassLoader[])new ClassLoader[]{portalCacheConfiguratorSettings.getClassLoader()}));
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Reconfiguring caches in cache manager ", this.getPortalCacheManagerName(), " using ", url}));
            }
            this.reconfigurePortalCaches(url);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
        return true;
    }

    protected void removeConfigurableEhcachePortalCacheListeners(PortalCache<K, V> portalCache) {
        EhcachePortalCache ehcachePortalCache = (EhcachePortalCache)EhcacheUnwrapUtil.getWrappedPortalCache(portalCache);
        Map portalCacheListeners = ehcachePortalCache.getPortalCacheListeners();
        for (PortalCacheListener portalCacheListener : portalCacheListeners.keySet()) {
            if (!(portalCacheListener instanceof ConfigurableEhcachePortalCacheListener)) continue;
            portalCache.unregisterPortalCacheListener(portalCacheListener);
        }
    }

    private class PortalCacheConfiguratorSettingsServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalCacheConfiguratorSettings, PortalCacheConfiguratorSettings> {
        private PortalCacheConfiguratorSettingsServiceTrackerCustomizer() {
        }

        public PortalCacheConfiguratorSettings addingService(ServiceReference<PortalCacheConfiguratorSettings> serviceReference) {
            PortalCacheConfiguratorSettings portalCacheConfiguratorSettings = (PortalCacheConfiguratorSettings)EhcachePortalCacheManager.this.bundleContext.getService(serviceReference);
            EhcachePortalCacheManager.this.reconfigure(portalCacheConfiguratorSettings);
            return portalCacheConfiguratorSettings;
        }

        public void modifiedService(ServiceReference<PortalCacheConfiguratorSettings> serviceReference, PortalCacheConfiguratorSettings portalCacheConfiguratorSettings) {
        }

        public void removedService(ServiceReference<PortalCacheConfiguratorSettings> serviceReference, PortalCacheConfiguratorSettings portalCacheConfiguratorSettings) {
            EhcachePortalCacheManager.this.bundleContext.ungetService(serviceReference);
        }
    }
}

