/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal.rmi;

import com.liferay.portal.cache.ehcache.internal.rmi.LiferayCacheDecorator;
import java.util.List;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerListenerFactory;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.distribution.RMICacheManagerPeerListenerFactory;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.RegisteredEventListeners;

public class LiferayRMICacheManagerPeerListenerFactory
extends CacheManagerPeerListenerFactory {
    private static final CacheReplicator _cacheReplicator = new CacheReplicator(){

        public boolean alive() {
            return true;
        }

        public Object clone() {
            return this;
        }

        public void dispose() {
        }

        public boolean isReplicateUpdatesViaCopy() {
            return false;
        }

        public boolean notAlive() {
            return false;
        }

        public void notifyElementEvicted(Ehcache ehcache, Element element) {
        }

        public void notifyElementExpired(Ehcache ehcache, Element element) {
        }

        public void notifyElementPut(Ehcache ehcache, Element element) {
        }

        public void notifyElementRemoved(Ehcache ehcache, Element element) {
        }

        public void notifyElementUpdated(Ehcache ehcache, Element element) {
        }

        public void notifyRemoveAll(Ehcache ehch) {
        }
    };
    private final CacheManagerPeerListenerFactory _cacheManagerPeerListenerFactory = new RMICacheManagerPeerListenerFactory();

    public CacheManagerPeerListener createCachePeerListener(CacheManager cacheManager, Properties properties) {
        CacheManagerPeerListener cacheManagerPeerListener = this._cacheManagerPeerListenerFactory.createCachePeerListener(cacheManager, properties);
        return new LiferayCacheManagerPeerListener(cacheManager, cacheManagerPeerListener);
    }

    private static class LiferayCacheManagerPeerListener
    implements CacheManagerPeerListener {
        private final CacheManager _cacheManager;
        private final CacheManagerPeerListener _cacheManagerPeerListener;

        public void attemptResolutionOfUniqueResourceConflict() {
            this._cacheManagerPeerListener.attemptResolutionOfUniqueResourceConflict();
        }

        public void dispose() {
            this._cacheManagerPeerListener.dispose();
        }

        public List getBoundCachePeers() {
            return this._cacheManagerPeerListener.getBoundCachePeers();
        }

        public String getScheme() {
            return this._cacheManagerPeerListener.getScheme();
        }

        public Status getStatus() {
            return this._cacheManagerPeerListener.getStatus();
        }

        public String getUniqueResourceIdentifier() {
            return this._cacheManagerPeerListener.getUniqueResourceIdentifier();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            for (String cacheName : this._cacheManager.getCacheNames()) {
                this._wrapEhcache(cacheName);
            }
            try {
                this._cacheManagerPeerListener.init();
            }
            finally {
                for (String cacheName : this._cacheManager.getCacheNames()) {
                    this._unwrapEhcache(cacheName);
                }
            }
        }

        public void notifyCacheAdded(String cacheName) {
            this._wrapEhcache(cacheName);
            try {
                this._cacheManagerPeerListener.notifyCacheAdded(cacheName);
            }
            finally {
                this._unwrapEhcache(cacheName);
            }
        }

        public void notifyCacheRemoved(String cacheName) {
            this._cacheManagerPeerListener.notifyCacheRemoved(cacheName);
        }

        private LiferayCacheManagerPeerListener(CacheManager cacheManager, CacheManagerPeerListener cacheManagerPeerListener) {
            this._cacheManager = cacheManager;
            this._cacheManagerPeerListener = cacheManagerPeerListener;
        }

        private void _unwrapEhcache(String cacheName) {
            Ehcache ehcache = this._cacheManager.getEhcache(cacheName);
            if (!(ehcache instanceof LiferayCacheDecorator)) {
                return;
            }
            RegisteredEventListeners registeredEventListeners = ehcache.getCacheEventNotificationService();
            LiferayCacheDecorator liferayCacheDecorator = (LiferayCacheDecorator)ehcache;
            this._cacheManager.replaceCacheWithDecoratedCache((Ehcache)liferayCacheDecorator, liferayCacheDecorator.getUnderlyingCache());
            registeredEventListeners.unregisterListener((CacheEventListener)_cacheReplicator);
        }

        private void _wrapEhcache(String cacheName) {
            Ehcache ehcache = this._cacheManager.getEhcache(cacheName);
            if (!(ehcache instanceof LiferayCacheDecorator)) {
                this._cacheManager.replaceCacheWithDecoratedCache(ehcache, (Ehcache)new LiferayCacheDecorator(ehcache));
            }
            RegisteredEventListeners registeredEventListeners = ehcache.getCacheEventNotificationService();
            registeredEventListeners.registerListener((CacheEventListener)_cacheReplicator);
        }
    }
}

