/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.cache.BasePortalCacheManager;
import com.liferay.portal.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCache;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCacheConfiguration;
import com.liferay.portal.cache.ehcache.internal.SerializableEhcachePortalCache;
import com.liferay.portal.cache.ehcache.internal.configurator.BaseEhcachePortalCacheManagerConfigurator;
import com.liferay.portal.cache.ehcache.internal.event.PortalCacheManagerEventListener;
import com.liferay.portal.cache.ehcache.spi.EhcacheUnwrapUtil;
import com.liferay.portal.cache.ehcache.spi.event.ConfigurableEhcachePortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.cache.configurator.PortalCacheConfiguratorSettings;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import javax.management.MBeanServer;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerRegistry;
import net.sf.ehcache.management.ManagementService;
import net.sf.ehcache.util.FailSafeTimer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class EhcachePortalCacheManager<K extends Serializable, V>
extends BasePortalCacheManager<K, V> {
    protected BaseEhcachePortalCacheManagerConfigurator baseEhcachePortalCacheManagerConfigurator;
    protected MBeanServer mBeanServer;
    protected volatile Props props;
    private static final Log _log = LogFactoryUtil.getLog(EhcachePortalCacheManager.class);
    private CacheManager _cacheManager;
    private String _configFile;
    private String _defaultConfigFile;
    private ManagementService _managementService;
    private PortalCacheManagerConfiguration _portalCacheManagerConfiguration;
    private boolean _registerCacheConfigurations = true;
    private boolean _registerCacheManager = true;
    private boolean _registerCaches = true;
    private boolean _registerCacheStatistics = true;
    private ServiceTracker _serviceTracker;
    private boolean _stopCacheManagerTimer = true;
    private boolean _usingDefault;

    public CacheManager getEhcacheManager() {
        return this._cacheManager;
    }

    public void reconfigurePortalCaches(URL configurationURL) {
        ObjectValuePair<Configuration, PortalCacheManagerConfiguration> configurationObjectValuePair = this.baseEhcachePortalCacheManagerConfigurator.getConfigurationObjectValuePair(this.getPortalCacheManagerName(), configurationURL, this._usingDefault);
        this.reconfigEhcache((Configuration)configurationObjectValuePair.getKey());
        this.reconfigPortalCache((PortalCacheManagerConfiguration)configurationObjectValuePair.getValue());
    }

    public void setConfigFile(String configFile) {
        this._configFile = configFile;
    }

    public void setDefaultConfigFile(String defaultConfigFile) {
        this._defaultConfigFile = defaultConfigFile;
    }

    public void setRegisterCacheConfigurations(boolean registerCacheConfigurations) {
        this._registerCacheConfigurations = registerCacheConfigurations;
    }

    public void setRegisterCacheManager(boolean registerCacheManager) {
        this._registerCacheManager = registerCacheManager;
    }

    public void setRegisterCaches(boolean registerCaches) {
        this._registerCaches = registerCaches;
    }

    public void setRegisterCacheStatistics(boolean registerCacheStatistics) {
        this._registerCacheStatistics = registerCacheStatistics;
    }

    public void setStopCacheManagerTimer(boolean stopCacheManagerTimer) {
        this._stopCacheManagerTimer = stopCacheManagerTimer;
    }

    protected Ehcache createEhcache(String portalCacheName, CacheConfiguration cacheConfiguration) {
        if (this._cacheManager.cacheExists(portalCacheName)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Overriding existing cache " + portalCacheName));
            }
            this._cacheManager.removeCache(portalCacheName);
        }
        Cache cache = new Cache(cacheConfiguration);
        this._cacheManager.addCache(cache);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortalCache<K, V> createPortalCache(PortalCacheConfiguration portalCacheConfiguration) {
        String portalCacheName = portalCacheConfiguration.getPortalCacheName();
        CacheManager cacheManager = this._cacheManager;
        synchronized (cacheManager) {
            if (!this._cacheManager.cacheExists(portalCacheName)) {
                this._cacheManager.addCache(portalCacheName);
            }
        }
        Cache cache = this._cacheManager.getCache(portalCacheName);
        EhcachePortalCacheConfiguration ehcachePortalCacheConfiguration = (EhcachePortalCacheConfiguration)portalCacheConfiguration;
        if (ehcachePortalCacheConfiguration.isRequireSerialization()) {
            return new SerializableEhcachePortalCache(this, (Ehcache)cache);
        }
        return new EhcachePortalCache(this, (Ehcache)cache);
    }

    protected void doClearAll() {
        for (String cacheName : this._cacheManager.getCacheNames()) {
            Cache cache = this._cacheManager.getCache(cacheName);
            if (cache == null) continue;
            cache.removeAll();
        }
    }

    protected void doDestroy() {
        this._cacheManager.shutdown();
        if (this._managementService != null) {
            this._managementService.dispose();
        }
        if (this._serviceTracker != null) {
            this._serviceTracker.close();
            this._serviceTracker = null;
        }
    }

    protected void doRemovePortalCache(String portalCacheName) {
        this._cacheManager.removeCache(portalCacheName);
    }

    protected PortalCacheManagerConfiguration getPortalCacheManagerConfiguration() {
        return this._portalCacheManagerConfiguration;
    }

    protected void initPortalCacheConfiguratorSettingsServiceTracker(BundleContext bundleContext) {
        String filterString = StringBundler.concat((String[])new String[]{"(&(objectClass=", PortalCacheConfiguratorSettings.class.getName(), ")(", "portal.cache.manager.name", "=", this.getPortalCacheManagerName(), "))"});
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, (String)filterString, (ServiceTrackerCustomizer)new PortalCacheConfiguratorSettingsServiceTrackerCustomizer(bundleContext));
    }

    protected void initPortalCacheManager() {
        URL configFileURL;
        this.setBlockingPortalCacheAllowed(GetterUtil.getBoolean((String)this.props.get("ehcache.blocking.cache.allowed")));
        this.setTransactionalPortalCacheEnabled(GetterUtil.getBoolean((String)this.props.get("transactional.cache.enable")));
        this.setTransactionalPortalCacheNames(GetterUtil.getStringValues((String[])this.props.getArray("transactional.cache.names")));
        if (Validator.isNull((String)this._configFile)) {
            this._configFile = this._defaultConfigFile;
        }
        if ((configFileURL = BaseEhcachePortalCacheManagerConfigurator.class.getResource(this._configFile)) == null) {
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            configFileURL = classLoader.getResource(this._configFile);
        }
        this._usingDefault = this._configFile.equals(this._defaultConfigFile);
        ObjectValuePair<Configuration, PortalCacheManagerConfiguration> configurationObjectValuePair = this.baseEhcachePortalCacheManagerConfigurator.getConfigurationObjectValuePair(this.getPortalCacheManagerName(), configFileURL, this._usingDefault);
        this._cacheManager = new CacheManager((Configuration)configurationObjectValuePair.getKey());
        this._portalCacheManagerConfiguration = (PortalCacheManagerConfiguration)configurationObjectValuePair.getValue();
        if (this._stopCacheManagerTimer) {
            FailSafeTimer failSafeTimer = this._cacheManager.getTimer();
            failSafeTimer.cancel();
            try {
                Field cacheManagerTimerField = ReflectionUtil.getDeclaredField(CacheManager.class, (String)"cacheManagerTimer");
                cacheManagerTimerField.set(this._cacheManager, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        CacheManagerEventListenerRegistry cacheManagerEventListenerRegistry = this._cacheManager.getCacheManagerEventListenerRegistry();
        cacheManagerEventListenerRegistry.registerListener((CacheManagerEventListener)new PortalCacheManagerEventListener((PortalCacheManagerListener)this.aggregatedPortalCacheManagerListener));
        if (GetterUtil.getBoolean((String)this.props.get("ehcache.portal.cache.manager.jmx.enabled"))) {
            this._managementService = new ManagementService(this._cacheManager, this.mBeanServer, this._registerCacheManager, this._registerCaches, this._registerCacheConfigurations, this._registerCacheStatistics);
            this._managementService.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconfigEhcache(Configuration configuration) {
        Map cacheConfigurations = configuration.getCacheConfigurations();
        for (CacheConfiguration cacheConfiguration : cacheConfigurations.values()) {
            String portalCacheName = cacheConfiguration.getName();
            CacheManager cacheManager = this._cacheManager;
            synchronized (cacheManager) {
                Ehcache ehcache = this.createEhcache(portalCacheName, cacheConfiguration);
                PortalCache portalCache = (PortalCache)this.portalCaches.get(portalCacheName);
                if (portalCache != null) {
                    EhcachePortalCache ehcachePortalCache = (EhcachePortalCache)EhcacheUnwrapUtil.getWrappedPortalCache((PortalCache)portalCache);
                    if (ehcachePortalCache != null) {
                        ehcachePortalCache.reconfigEhcache(ehcache);
                    } else {
                        _log.error((Object)("Unable to reconfigure cache with name " + portalCacheName));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean reconfigure(PortalCacheConfiguratorSettings portalCacheConfiguratorSettings) {
        String portalCacheConfigurationLocation = portalCacheConfiguratorSettings.getPortalCacheConfigrationLocation();
        if (Validator.isNull((String)portalCacheConfigurationLocation)) {
            return false;
        }
        ClassLoader classLoader = portalCacheConfiguratorSettings.getClassLoader();
        URL url = classLoader.getResource(portalCacheConfigurationLocation);
        if (url == null) {
            return false;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(AggregateClassLoader.getAggregateClassLoader((ClassLoader)PortalClassLoaderUtil.getClassLoader(), (ClassLoader[])new ClassLoader[]{portalCacheConfiguratorSettings.getClassLoader()}));
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Reconfiguring caches in cache manager ", this.getPortalCacheManagerName(), " using ", String.valueOf(url)}));
            }
            this.reconfigurePortalCaches(url);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
        return true;
    }

    protected void removeConfigurableEhcachePortalCacheListeners(PortalCache<K, V> portalCache) {
        EhcachePortalCache ehcachePortalCache = (EhcachePortalCache)EhcacheUnwrapUtil.getWrappedPortalCache(portalCache);
        Map portalCacheListeners = ehcachePortalCache.getPortalCacheListeners();
        for (PortalCacheListener portalCacheListener : portalCacheListeners.keySet()) {
            if (!(portalCacheListener instanceof ConfigurableEhcachePortalCacheListener)) continue;
            portalCache.unregisterPortalCacheListener(portalCacheListener);
        }
    }

    private class PortalCacheConfiguratorSettingsServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalCacheConfiguratorSettings, PortalCacheConfiguratorSettings> {
        private final BundleContext _bundleContext;

        public PortalCacheConfiguratorSettings addingService(ServiceReference<PortalCacheConfiguratorSettings> serviceReference) {
            PortalCacheConfiguratorSettings portalCacheConfiguratorSettings = (PortalCacheConfiguratorSettings)this._bundleContext.getService(serviceReference);
            EhcachePortalCacheManager.this.reconfigure(portalCacheConfiguratorSettings);
            return portalCacheConfiguratorSettings;
        }

        public void modifiedService(ServiceReference<PortalCacheConfiguratorSettings> serviceReference, PortalCacheConfiguratorSettings portalCacheConfiguratorSettings) {
        }

        public void removedService(ServiceReference<PortalCacheConfiguratorSettings> serviceReference, PortalCacheConfiguratorSettings portalCacheConfiguratorSettings) {
            this._bundleContext.ungetService(serviceReference);
        }

        private PortalCacheConfiguratorSettingsServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }
    }
}

