/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.portal.cache.PortalCacheWrapper;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.transactional.TransactionalPortalCacheUtil;
import java.io.Serializable;

public class TransactionalPortalCache<K extends Serializable, V>
extends PortalCacheWrapper<K, V> {
    private final boolean _mvcc;

    public TransactionalPortalCache(PortalCache<K, V> portalCache, boolean mvcc) {
        super(portalCache);
        this._mvcc = mvcc;
    }

    @Override
    public V get(K key) {
        Object result = null;
        if (TransactionalPortalCacheUtil.isEnabled()) {
            if (key == null) {
                throw new NullPointerException("Key is null");
            }
            result = TransactionalPortalCacheUtil.get((PortalCache)this.portalCache, key);
            if (result == TransactionalPortalCacheUtil.getNullHolder()) {
                return null;
            }
        }
        if (result == null) {
            result = this.portalCache.get(key);
        }
        return (V)result;
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, 0);
    }

    @Override
    public void put(K key, V value, int timeToLive) {
        if (TransactionalPortalCacheUtil.isEnabled()) {
            if (key == null) {
                throw new NullPointerException("Key is null");
            }
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (timeToLive < 0) {
                throw new IllegalArgumentException("Time to live is negative");
            }
            TransactionalPortalCacheUtil.put((PortalCache)this.portalCache, key, value, (int)timeToLive, (boolean)this._mvcc);
        } else {
            this.portalCache.put(key, value, timeToLive);
        }
    }

    @Override
    public void remove(K key) {
        if (TransactionalPortalCacheUtil.isEnabled()) {
            if (key == null) {
                throw new NullPointerException("Key is null");
            }
            TransactionalPortalCacheUtil.put((PortalCache)this.portalCache, key, (Object)TransactionalPortalCacheUtil.getNullHolder(), (int)0, (boolean)this._mvcc);
        } else {
            this.portalCache.remove(key);
        }
    }

    @Override
    public void removeAll() {
        if (TransactionalPortalCacheUtil.isEnabled()) {
            TransactionalPortalCacheUtil.removeAll((PortalCache)this.portalCache, (boolean)this._mvcc);
        } else {
            this.portalCache.removeAll();
        }
    }
}

