/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.portal.cache.AggregatedPortalCacheListener;
import com.liferay.portal.cache.LowLevelCache;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import java.io.Serializable;

public abstract class BasePortalCache<K extends Serializable, V>
implements LowLevelCache<K, V> {
    protected final AggregatedPortalCacheListener<K, V> aggregatedPortalCacheListener = new AggregatedPortalCacheListener();
    private final PortalCacheManager<K, V> _portalCacheManager;

    public BasePortalCache(PortalCacheManager<K, V> portalCacheManager) {
        this._portalCacheManager = portalCacheManager;
    }

    public V get(K key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        return this.doGet(key);
    }

    public PortalCacheManager<K, V> getPortalCacheManager() {
        return this._portalCacheManager;
    }

    public boolean isBlocking() {
        return false;
    }

    public boolean isMVCC() {
        return false;
    }

    public void put(K key, V value) {
        this.put(key, value, 0);
    }

    public void put(K key, V value, int timeToLive) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        if (timeToLive < 0) {
            throw new IllegalArgumentException("Time to live is negative");
        }
        this.doPut(key, value, timeToLive);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, 0);
    }

    @Override
    public V putIfAbsent(K key, V value, int timeToLive) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        if (timeToLive < 0) {
            throw new IllegalArgumentException("Time to live is negative");
        }
        return this.doPutIfAbsent(key, value, timeToLive);
    }

    public void registerPortalCacheListener(PortalCacheListener<K, V> portalCacheListener) {
        this.aggregatedPortalCacheListener.addPortalCacheListener(portalCacheListener);
    }

    public void registerPortalCacheListener(PortalCacheListener<K, V> portalCacheListener, PortalCacheListenerScope portalCacheListenerScope) {
        this.aggregatedPortalCacheListener.addPortalCacheListener(portalCacheListener, portalCacheListenerScope);
    }

    public void remove(K key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        this.doRemove(key);
    }

    @Override
    public boolean remove(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        return this.doRemove(key, value);
    }

    @Override
    public V replace(K key, V value) {
        return this.replace(key, value, 0);
    }

    @Override
    public V replace(K key, V value, int timeToLive) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        if (timeToLive < 0) {
            throw new IllegalArgumentException("Time to live is negative");
        }
        return this.doReplace(key, value, timeToLive);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, 0);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue, int timeToLive) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (oldValue == null) {
            throw new NullPointerException("Old value is null");
        }
        if (newValue == null) {
            throw new NullPointerException("New value is null");
        }
        if (timeToLive < 0) {
            throw new IllegalArgumentException("Time to live is negative");
        }
        return this.doReplace(key, oldValue, newValue, timeToLive);
    }

    public void unregisterPortalCacheListener(PortalCacheListener<K, V> portalCacheListener) {
        this.aggregatedPortalCacheListener.removePortalCacheListener(portalCacheListener);
    }

    public void unregisterPortalCacheListeners() {
        this.aggregatedPortalCacheListener.clearAll();
    }

    protected abstract V doGet(K var1);

    protected abstract void doPut(K var1, V var2, int var3);

    protected abstract V doPutIfAbsent(K var1, V var2, int var3);

    protected abstract void doRemove(K var1);

    protected abstract boolean doRemove(K var1, V var2);

    protected abstract V doReplace(K var1, V var2, int var3);

    protected abstract boolean doReplace(K var1, V var2, V var3, int var4);
}

