/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.portal.cache.PortalCacheWrapper;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.transactional.TransactionalPortalCacheHelper;
import java.io.Serializable;

public class TransactionalPortalCache<K extends Serializable, V>
extends PortalCacheWrapper<K, V> {
    public TransactionalPortalCache(PortalCache<K, V> portalCache) {
        super(portalCache);
    }

    @Override
    public V get(K key) {
        Object result = null;
        if (TransactionalPortalCacheHelper.isEnabled()) {
            if (key == null) {
                throw new NullPointerException("Key is null");
            }
            result = TransactionalPortalCacheHelper.get((PortalCache)this.portalCache, key);
            if (result == TransactionalPortalCacheHelper.getNullHolder()) {
                return null;
            }
        }
        if (result == null) {
            result = this.portalCache.get(key);
        }
        return (V)result;
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, 0);
    }

    @Override
    public void put(K key, V value, int timeToLive) {
        if (TransactionalPortalCacheHelper.isEnabled()) {
            if (key == null) {
                throw new NullPointerException("Key is null");
            }
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (timeToLive < 0) {
                throw new IllegalArgumentException("Time to live is negative");
            }
            TransactionalPortalCacheHelper.put((PortalCache)this.portalCache, key, value, (int)timeToLive);
        } else {
            this.portalCache.put(key, value, timeToLive);
        }
    }

    @Override
    public void remove(K key) {
        if (TransactionalPortalCacheHelper.isEnabled()) {
            if (key == null) {
                throw new NullPointerException("Key is null");
            }
            TransactionalPortalCacheHelper.put((PortalCache)this.portalCache, key, (Object)TransactionalPortalCacheHelper.getNullHolder(), (int)0);
        } else {
            this.portalCache.remove(key);
        }
    }

    @Override
    public void removeAll() {
        if (TransactionalPortalCacheHelper.isEnabled()) {
            TransactionalPortalCacheHelper.removeAll((PortalCache)this.portalCache);
        } else {
            this.portalCache.removeAll();
        }
    }
}

