/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.url.pattern.mapper.internal;

import com.liferay.petra.url.pattern.mapper.internal.BaseURLPatternMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SimpleURLPatternMapper<T>
extends BaseURLPatternMapper<T> {
    private final Map<String, T> _exactURLPatternValues = new HashMap<String, T>();
    private final Map<String, T> _extensionURLPatternValues = new HashMap<String, T>();
    private final Map<String, T> _wildcardURLPatternValues = new HashMap<String, T>();

    public SimpleURLPatternMapper(Map<String, T> values) {
        for (Map.Entry<String, T> entry : values.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void consumeValues(Consumer<T> consumer, String urlPath) {
        if (Objects.isNull(urlPath)) {
            return;
        }
        T value = this._exactURLPatternValues.get(urlPath);
        if (Objects.nonNull(value)) {
            consumer.accept(value);
        }
        if (Objects.nonNull(value = this._wildcardURLPatternValues.get(urlPath + "/*"))) {
            consumer.accept(value);
        }
        int index = 0;
        for (int i = urlPath.length(); i > 0; --i) {
            if (index < 1 && urlPath.charAt(i - 1) == '.') {
                index = i - 1;
            }
            if (urlPath.charAt(i - 1) != '/' || !Objects.nonNull(value = this._wildcardURLPatternValues.get(urlPath.substring(0, i) + "*"))) continue;
            consumer.accept(value);
        }
        value = this._extensionURLPatternValues.get("*" + urlPath.substring(index));
        if (Objects.nonNull(value)) {
            consumer.accept(value);
        }
    }

    @Override
    public T getValue(String urlPath) {
        if (Objects.isNull(urlPath)) {
            return null;
        }
        T value = this._exactURLPatternValues.get(urlPath);
        if (Objects.nonNull(value)) {
            return value;
        }
        value = this._wildcardURLPatternValues.get(urlPath + "/*");
        if (Objects.nonNull(value)) {
            return value;
        }
        int index = 0;
        for (int i = urlPath.length(); i > 0; --i) {
            if (index < 1 && urlPath.charAt(i - 1) == '.') {
                index = i - 1;
            }
            if (urlPath.charAt(i - 1) != '/' || !Objects.nonNull(value = this._wildcardURLPatternValues.get(urlPath.substring(0, i) + "*"))) continue;
            return value;
        }
        return this._extensionURLPatternValues.get("*" + urlPath.substring(index));
    }

    @Override
    protected void put(String urlPattern, T value) throws IllegalArgumentException {
        if (Objects.isNull(urlPattern) || urlPattern.length() == 0) {
            throw new IllegalArgumentException("URL pattern is blank");
        }
        if (this.isWildcardURLPattern(urlPattern)) {
            this._wildcardURLPatternValues.put(urlPattern, value);
            return;
        }
        if (this.isExtensionURLPattern(urlPattern)) {
            this._extensionURLPatternValues.put(urlPattern, value);
            return;
        }
        this._exactURLPatternValues.put(urlPattern, value);
    }
}

