/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.url.pattern.mapper.internal;

import com.liferay.petra.url.pattern.mapper.URLPatternMapper;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class BaseURLPatternMapper<T>
implements URLPatternMapper<T> {
    protected boolean isExtensionURLPattern(String urlPattern) {
        if (urlPattern.length() < 3 || urlPattern.charAt(0) != '*' || urlPattern.charAt(1) != '.') {
            return false;
        }
        for (int i = 2; i < urlPattern.length(); ++i) {
            if (urlPattern.charAt(i) != '/' && urlPattern.charAt(i) != '.') continue;
            return false;
        }
        return true;
    }

    protected boolean isWildcardURLPattern(String urlPattern) {
        if (urlPattern.length() < 2 || urlPattern.charAt(0) != '/' || urlPattern.charAt(urlPattern.length() - 1) != '*' || urlPattern.charAt(urlPattern.length() - 2) != '/') {
            return false;
        }
        try {
            String urlPath = urlPattern.substring(0, urlPattern.length() - 1);
            URI uri = new URI("https://test" + urlPath);
            if (!urlPath.contentEquals(uri.getPath())) {
                return false;
            }
        }
        catch (URISyntaxException uriSyntaxException) {
            return false;
        }
        return true;
    }

    protected abstract void put(String var1, T var2) throws IllegalArgumentException;
}

