/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.url.pattern.mapper.internal;

import com.liferay.petra.url.pattern.mapper.internal.BaseTrieURLPatternMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DynamicSizeTrieURLPatternMapper<T>
extends BaseTrieURLPatternMapper<T> {
    private final TrieNode _extensionTrieNode;
    private final TrieNodeHeap _trieNodeHeap = new TrieNodeHeap();
    private final TrieNode _wildCardTrieNode;

    public DynamicSizeTrieURLPatternMapper(Map<String, T> values) {
        this._extensionTrieNode = this._trieNodeHeap.nextAvailableTrieNode();
        this._wildCardTrieNode = this._trieNodeHeap.nextAvailableTrieNode();
        for (Map.Entry<String, T> entry : values.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected void consumeWildcardValues(Consumer<T> consumer, String urlPath) {
        boolean exact = false;
        boolean wildcard = false;
        if (urlPath.charAt(0) != '/') {
            exact = true;
        } else if (urlPath.length() > 1 && urlPath.charAt(urlPath.length() - 2) == '/' && urlPath.charAt(urlPath.length() - 1) == '*') {
            wildcard = true;
        }
        TrieNode currentTrieNode = null;
        TrieNode previousTrieNode = this._wildCardTrieNode;
        for (int i = 0; i < urlPath.length() && (currentTrieNode = previousTrieNode.getNextTrieNode(urlPath.charAt(i))) != null; ++i) {
            TrieNode nextTrieNode;
            if (!exact && urlPath.charAt(i) == '/' && (nextTrieNode = currentTrieNode.getNextTrieNode('*')) != null && nextTrieNode.isEnd()) {
                consumer.accept(nextTrieNode.getValue());
            }
            previousTrieNode = currentTrieNode;
        }
        if (currentTrieNode != null) {
            if (exact) {
                if (currentTrieNode.isEnd()) {
                    consumer.accept(currentTrieNode.getValue());
                }
                return;
            }
            if (!wildcard && currentTrieNode.isEnd()) {
                consumer.accept(currentTrieNode.getValue());
            }
            if ((currentTrieNode = currentTrieNode.getNextTrieNode('/')) != null && (currentTrieNode = currentTrieNode.getNextTrieNode('*')) != null && currentTrieNode.isEnd()) {
                consumer.accept(currentTrieNode.getValue());
            }
        }
    }

    @Override
    protected T getExtensionValue(String urlPath) {
        int index;
        char character;
        TrieNode currentTrieNode = null;
        TrieNode previousTrieNode = this._extensionTrieNode;
        for (int i = 0; i < urlPath.length() && (character = urlPath.charAt(index = urlPath.length() - 1 - i)) != '/' && !Objects.isNull(currentTrieNode = previousTrieNode.getNextTrieNode(character)); ++i) {
            if (urlPath.charAt(index) == '.') {
                TrieNode nextTrieNode = currentTrieNode.getNextTrieNode('*');
                return nextTrieNode.getValue();
            }
            previousTrieNode = currentTrieNode;
        }
        return null;
    }

    @Override
    protected T getWildcardValue(String urlPath) {
        boolean exact = false;
        boolean wildcard = false;
        if (urlPath.charAt(0) != '/') {
            exact = true;
        } else if (urlPath.length() > 1 && urlPath.charAt(urlPath.length() - 2) == '/' && urlPath.charAt(urlPath.length() - 1) == '*') {
            wildcard = true;
        }
        T value = null;
        TrieNode currentTrieNode = null;
        TrieNode previousTrieNode = this._wildCardTrieNode;
        for (int i = 0; i < urlPath.length() && !Objects.isNull(currentTrieNode = previousTrieNode.getNextTrieNode(urlPath.charAt(i))); ++i) {
            TrieNode nextTrieNode;
            if (!exact && urlPath.charAt(i) == '/' && Objects.nonNull(nextTrieNode = currentTrieNode.getNextTrieNode('*')) && nextTrieNode.isEnd()) {
                value = nextTrieNode.getValue();
            }
            previousTrieNode = currentTrieNode;
        }
        if (Objects.nonNull(currentTrieNode)) {
            if (exact) {
                if (!currentTrieNode.isEnd()) {
                    return null;
                }
                return currentTrieNode.getValue();
            }
            if (!wildcard && currentTrieNode.isEnd()) {
                return currentTrieNode.getValue();
            }
            if (Objects.nonNull(currentTrieNode = currentTrieNode.getNextTrieNode('/')) && Objects.nonNull(currentTrieNode = currentTrieNode.getNextTrieNode('*')) && currentTrieNode.isEnd()) {
                value = currentTrieNode.getValue();
            }
        }
        return value;
    }

    @Override
    protected void put(String urlPattern, T value, boolean wildcard) {
        TrieNode previousTrieNode = null;
        previousTrieNode = wildcard ? this._wildCardTrieNode : this._extensionTrieNode;
        TrieNode currentTrieNode = null;
        for (int i = 0; i < urlPattern.length(); ++i) {
            int index = i;
            if (!wildcard) {
                index = urlPattern.length() - 1 - i;
            }
            if (Objects.isNull(currentTrieNode = previousTrieNode.getNextTrieNode(urlPattern.charAt(index)))) {
                TrieNode nextTrieNode = this._trieNodeHeap.nextAvailableTrieNode();
                currentTrieNode = previousTrieNode.setNextTrieNode(urlPattern.charAt(index), nextTrieNode);
            }
            previousTrieNode = currentTrieNode;
        }
        currentTrieNode.setValue(value);
    }

    private class TrieNodeHeap {
        private static final int _SIZE = 1024;
        private int _nextAvailableTrieNodeIndex;
        private ArrayList<TrieNode> _trieNodes = new ArrayList(1024);

        public TrieNodeHeap() {
            for (int i = 0; i < 1024; ++i) {
                this._trieNodes.add(new TrieNode());
            }
        }

        public TrieNode nextAvailableTrieNode() {
            if (this._nextAvailableTrieNodeIndex >= this._trieNodes.size()) {
                this._trieNodes.ensureCapacity(this._trieNodes.size() + 1024);
                for (int i = 0; i < 1024; ++i) {
                    this._trieNodes.add(new TrieNode());
                }
            }
            return this._trieNodes.get(this._nextAvailableTrieNodeIndex++);
        }
    }

    private class TrieNode {
        private final List<TrieNode> _trieNodes = new ArrayList<TrieNode>(96);
        private T _value;

        public TrieNode() {
            for (int i = 0; i < 96; ++i) {
                this._trieNodes.add(null);
            }
        }

        public TrieNode getNextTrieNode(char character) {
            return this._trieNodes.get(character - 32);
        }

        public T getValue() {
            return this._value;
        }

        public boolean isEnd() {
            return Objects.nonNull(this._value);
        }

        public TrieNode setNextTrieNode(char character, TrieNode nextTrieNode) {
            this._trieNodes.set(character - 32, nextTrieNode);
            return nextTrieNode;
        }

        public void setValue(T value) {
            this._value = value;
        }
    }
}

