/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.url.pattern.mapper.internal;

import com.liferay.petra.url.pattern.mapper.internal.BaseURLPatternMapper;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class BaseTrieURLPatternMapper<T>
extends BaseURLPatternMapper<T> {
    protected static final byte ASCII_CHARACTER_RANGE = 96;
    protected static final byte ASCII_PRINTABLE_OFFSET = 32;

    @Override
    public void consumeValues(Consumer<T> consumer, String urlPath) {
        if (Objects.isNull(urlPath)) {
            return;
        }
        this.consumeWildcardValues(consumer, urlPath);
        T extensionValue = this.getExtensionValue(urlPath);
        if (extensionValue != null) {
            consumer.accept(extensionValue);
        }
    }

    @Override
    public T getValue(String urlPath) {
        if (Objects.isNull(urlPath)) {
            return null;
        }
        try {
            T value = this.getWildcardValue(urlPath);
            if (Objects.nonNull(value)) {
                return value;
            }
            return this.getExtensionValue(urlPath);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("URL path contains invalid characters", indexOutOfBoundsException);
        }
    }

    protected abstract void consumeWildcardValues(Consumer<T> var1, String var2);

    protected abstract T getExtensionValue(String var1);

    protected abstract T getWildcardValue(String var1);

    @Override
    protected void put(String urlPattern, T value) throws IllegalArgumentException {
        if (Objects.isNull(urlPattern) || urlPattern.length() == 0) {
            throw new IllegalArgumentException("URL pattern is blank");
        }
        if (Objects.isNull(value)) {
            throw new IllegalArgumentException("Value is null");
        }
        try {
            if (this.isWildcardURLPattern(urlPattern)) {
                this.put(urlPattern, value, true);
                return;
            }
            if (this.isExtensionURLPattern(urlPattern)) {
                this.put(urlPattern, value, false);
                return;
            }
            this.put(urlPattern, value, true);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("URL pattern contains invalid characters", indexOutOfBoundsException);
        }
    }

    protected abstract void put(String var1, T var2, boolean var3);
}

