/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.sql.dsl.spi.ast;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNode;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.spi.expression.Scalar;
import com.liferay.petra.sql.dsl.spi.expression.ScalarList;
import com.liferay.petra.sql.dsl.spi.query.Limit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DefaultASTNodeListener
implements ASTNodeListener {
    private int _end = -1;
    private final List<Object> _scalarValues = new ArrayList<Object>();
    private int _start = -1;
    private final Set<String> _tableNames = new LinkedHashSet<String>();

    public int getEnd() {
        return this._end;
    }

    public List<Object> getScalarValues() {
        return this._scalarValues;
    }

    public int getStart() {
        return this._start;
    }

    public String[] getTableNames() {
        return this._tableNames.toArray(new String[0]);
    }

    public void process(ASTNode astNode) {
        Table table;
        String tableName;
        if (astNode instanceof Limit) {
            Limit limit = (Limit)astNode;
            this._start = limit.getStart();
            this._end = limit.getEnd();
        } else if (astNode instanceof Scalar) {
            Scalar scalar = (Scalar)astNode;
            this._scalarValues.add(scalar.getValue());
        } else if (astNode instanceof ScalarList) {
            ScalarList scalarList = (ScalarList)astNode;
            Collections.addAll(this._scalarValues, scalarList.getValues());
        } else if (astNode instanceof Table && (tableName = (table = (Table)astNode).getTableName()) != null) {
            this._tableNames.add(tableName);
        }
    }
}

