/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.sql.dsl.spi.query;

import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.expression.Alias;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.spi.ast.BaseASTNode;
import com.liferay.petra.sql.dsl.spi.query.DefaultFromStep;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

public class Select
extends BaseASTNode
implements DefaultFromStep {
    private final boolean _distinct;
    private final Collection<? extends Expression<?>> _expressions;

    public Select(boolean distinct, Collection<? extends Expression<?>> expressions) {
        this._distinct = distinct;
        this._expressions = Objects.requireNonNull(expressions);
    }

    public Collection<? extends Expression<?>> getExpressions() {
        return this._expressions;
    }

    public boolean isDistinct() {
        return this._distinct;
    }

    @Override
    protected void doToSQL(Consumer<String> consumer, ASTNodeListener astNodeListener) {
        if (this._distinct) {
            consumer.accept("select distinct ");
        } else {
            consumer.accept("select ");
        }
        if (this._expressions.isEmpty()) {
            consumer.accept("*");
        } else {
            Iterator<Expression<?>> iterator = this._expressions.iterator();
            while (iterator.hasNext()) {
                Expression<?> expression = iterator.next();
                if (expression instanceof Alias) {
                    Alias alias = (Alias)expression;
                    Expression unwrappedExpression = alias.getExpression();
                    unwrappedExpression.toSQL(consumer, astNodeListener);
                    consumer.accept(" ");
                }
                expression.toSQL(consumer, astNodeListener);
                if (!iterator.hasNext()) continue;
                consumer.accept(", ");
            }
        }
    }
}

