/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.sql.dsl.spi.expression;

import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.spi.ast.BaseASTNode;
import com.liferay.petra.sql.dsl.spi.expression.DefaultExpression;
import java.util.Objects;
import java.util.function.Consumer;

public class AggregateExpression<T>
extends BaseASTNode
implements DefaultExpression<T> {
    private final boolean _distinct;
    private final Expression<?> _expression;
    private final String _name;

    public AggregateExpression(boolean distinct, Expression<?> expression, String name) {
        this._distinct = distinct;
        this._expression = expression;
        this._name = Objects.requireNonNull(name);
    }

    public Expression<?> getExpression() {
        return this._expression;
    }

    public String getName() {
        return this._name;
    }

    public boolean isDistinct() {
        return this._distinct;
    }

    @Override
    protected void doToSQL(Consumer<String> consumer, ASTNodeListener astNodeListener) {
        consumer.accept(this._name);
        consumer.accept("(");
        if (this._distinct) {
            consumer.accept("distinct ");
        }
        if (this._expression == null) {
            consumer.accept("*");
        } else {
            this._expression.toSQL(consumer, astNodeListener);
        }
        consumer.accept(")");
    }
}

