/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.sql.dsl.spi;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.base.BaseTable;
import com.liferay.petra.sql.dsl.expression.ColumnAlias;
import com.liferay.petra.sql.dsl.spi.ast.BaseASTNode;
import com.liferay.petra.sql.dsl.spi.expression.DefaultColumnAlias;
import com.liferay.petra.sql.dsl.spi.expression.DefaultExpression;
import java.util.Objects;
import java.util.function.Consumer;

public class DefaultColumn<T extends BaseTable<T>, C>
extends BaseASTNode
implements Column<T, C>,
DefaultExpression<C> {
    private final int _flags;
    private final Class<C> _javaType;
    private final String _name;
    private final int _sqlType;
    private final T _table;

    public DefaultColumn(T table, String name, Class<C> javaType, int sqlType, int flags) {
        this._table = (BaseTable)Objects.requireNonNull(table);
        this._name = Objects.requireNonNull(name);
        this._javaType = Objects.requireNonNull(javaType);
        this._sqlType = sqlType;
        if ((flags & 2) != 0) {
            flags |= 1;
        }
        this._flags = flags;
    }

    public ColumnAlias<T, C> as(String name) {
        if (this._name.equals(name)) {
            return new DefaultColumnAlias(this, name);
        }
        return new DefaultColumnAlias(this._table.aliasColumn((Column)this, name), name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Column)) {
            return false;
        }
        Column column = (Column)object;
        return this._name.equals(column.getName()) && this._table.equals((Object)column.getTable());
    }

    public int getFlags() {
        return this._flags;
    }

    public Class<C> getJavaType() {
        return this._javaType;
    }

    public String getName() {
        return this._name;
    }

    public int getSQLType() {
        return this._sqlType;
    }

    public T getTable() {
        return this._table;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (Object)this._name);
        return HashUtil.hash((int)hash, this._table);
    }

    @Override
    protected void doToSQL(Consumer<String> consumer, ASTNodeListener astNodeListener) {
        consumer.accept(this._table.getName());
        consumer.accept(".");
        consumer.accept(this._name);
    }
}

