/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.sql.dsl.base;

import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.factory.ColumnFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class BaseTable<T extends BaseTable<T>>
implements Table<T> {
    private static final ColumnFactory _COLUMN_FACTORY;
    private String _alias;
    private final Map<String, Column<T, ?>> _columnMap = new LinkedHashMap();
    private final String _tableName;
    private final Supplier<T> _tableSupplier;

    public BaseTable(String tableName, Supplier<T> tableSupplier) {
        this._tableName = tableName;
        this._tableSupplier = Objects.requireNonNull(tableSupplier);
    }

    public <C> Column<T, C> aliasColumn(Column<T, C> column, String columnAlias) {
        BaseTable table = (BaseTable)this._tableSupplier.get();
        table.setAlias(this._alias);
        column = _COLUMN_FACTORY.createColumn(table, column.getName(), column.getJavaType(), column.getSQLType(), column.getFlags());
        table.putColumn(columnAlias, column);
        return column;
    }

    @Override
    public T as(String alias) {
        BaseTable table = (BaseTable)this._tableSupplier.get();
        table.setAlias(alias);
        return (T)table;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Table)) {
            return false;
        }
        Table table = (Table)object;
        return this._tableName.equals(table.getTableName());
    }

    @Override
    public Column<T, ?> getColumn(String name) {
        return this._columnMap.get(name);
    }

    @Override
    public <C> Column<T, C> getColumn(String name, Class<C> clazz) {
        Column<T, ?> column = this._columnMap.get(name);
        if (column == null || !clazz.isAssignableFrom(column.getJavaType())) {
            return null;
        }
        return column;
    }

    @Override
    public Collection<Column<T, ?>> getColumns() {
        return Collections.unmodifiableCollection(this._columnMap.values());
    }

    @Override
    public String getName() {
        if (this._alias == null) {
            return this._tableName;
        }
        return this._alias;
    }

    @Override
    public String getTableName() {
        return this._tableName;
    }

    public int hashCode() {
        return this._tableName.hashCode();
    }

    @Override
    public void toSQL(Consumer<String> consumer, ASTNodeListener astNodeListener) {
        if (astNodeListener != null) {
            astNodeListener.process(this);
        }
        consumer.accept(this._tableName);
        if (this._alias != null) {
            consumer.accept(" ");
            consumer.accept(this._alias);
        }
    }

    public String toString() {
        return this.toSQL(null);
    }

    protected <C> Column<T, C> createColumn(String name, Class<C> javaType, int sqlType, int flags) {
        Column<BaseTable, C> column = _COLUMN_FACTORY.createColumn(this, name, javaType, sqlType, flags);
        this._columnMap.put(name, column);
        return column;
    }

    protected <C> void putColumn(String name, Column<T, C> column) {
        this._columnMap.put(name, column);
    }

    protected void setAlias(String alias) {
        this._alias = alias;
    }

    static {
        ServiceLoader<ColumnFactory> serviceLoader = ServiceLoader.load(ColumnFactory.class, ColumnFactory.class.getClassLoader());
        Iterator<ColumnFactory> iterator = serviceLoader.iterator();
        _COLUMN_FACTORY = iterator.next();
    }
}

