/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.on.demand.admin.internal.ticket.generator;

import com.liferay.on.demand.admin.internal.configuration.OnDemandAdminConfiguration;
import com.liferay.on.demand.admin.internal.helper.OnDemandAdminHelper;
import com.liferay.on.demand.admin.ticket.generator.OnDemandAdminTicketGenerator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TicketLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OnDemandAdminTicketGenerator.class})
public class OnDemandAdminTicketGeneratorImpl
implements OnDemandAdminTicketGenerator {
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private OnDemandAdminHelper _onDemandAdminHelper;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private TicketLocalService _ticketLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public Ticket generate(Company company, String justification, long requestorUserId) throws PortalException {
        this._onDemandAdminHelper.checkRequestAdministratorAccessPermission(company.getCompanyId(), requestorUserId);
        User user = this._addOnDemandAdminUser(company, requestorUserId);
        AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)"ON_DEMAND_ADMIN_TICKET_GENERATED", (String)User.class.getName(), (long)requestorUserId, null);
        auditMessage.setAdditionalInfo(JSONUtil.put((String)"justification", (Object)justification).put("requestedCompanyId", company.getCompanyId()).put("requestedCompanyWebId", company.getWebId()));
        this._auditRouter.route(auditMessage);
        OnDemandAdminConfiguration onDemandAdminConfiguration = (OnDemandAdminConfiguration)this._configurationProvider.getSystemConfiguration(OnDemandAdminConfiguration.class);
        int expirationTime = onDemandAdminConfiguration.authenticationTokenExpirationTime();
        return this._ticketLocalService.addDistinctTicket(user.getCompanyId(), User.class.getName(), user.getUserId(), 4, justification, new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(expirationTime)), null);
    }

    private User _addOnDemandAdminUser(Company company, long userId) throws PortalException {
        User requestorUser = this._userLocalService.getUser(userId);
        String password = PwdGenerator.getPassword((int)20);
        Date date = new Date();
        Role role = this._roleLocalService.getRole(company.getCompanyId(), "Administrator");
        User user = this._userLocalService.addUser(requestorUser.getUserId(), company.getCompanyId(), false, password, password, true, null, requestorUser.getEmailAddress(), requestorUser.getLocale(), requestorUser.getFirstName(), requestorUser.getMiddleName(), requestorUser.getLastName(), 0L, 0L, requestorUser.getMale(), date.getMonth(), date.getDay(), date.getYear(), null, null, null, new long[]{role.getRoleId()}, null, false, new ServiceContext());
        String screenName = this._getScreenName(requestorUser.getUserId(), user.getUserId());
        user.setScreenName(screenName);
        user.setEmailAddress(screenName + "@" + company.getMx());
        user.setEmailAddressVerified(true);
        return this._userLocalService.updateUser(user);
    }

    private String _getScreenName(long requestorUserId, long userId) throws PortalException {
        return StringBundler.concat((Object[])new Object[]{"on_demand_admin", "_", requestorUserId, "_", userId});
    }
}

