/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.on.demand.admin.internal.messaging;

import com.liferay.on.demand.admin.internal.configuration.OnDemandAdminConfiguration;
import com.liferay.on.demand.admin.manager.OnDemandAdminManager;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.instances.on.demand.admin.internal.configuration.OnDemandAdminConfiguration"}, service={MessageListener.class})
public class OnDemandAdminCleanerMessageListener
extends BaseMessageListener {
    private volatile OnDemandAdminConfiguration _onDemandAdminConfiguration;
    @Reference
    private OnDemandAdminManager _onDemandAdminManager;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._onDemandAdminConfiguration = (OnDemandAdminConfiguration)ConfigurableUtil.createConfigurable(OnDemandAdminConfiguration.class, properties);
        int cleanUpInterval = this._onDemandAdminConfiguration.cleanUpInterval();
        Trigger trigger = this._triggerFactory.createTrigger(OnDemandAdminCleanerMessageListener.class.getName(), OnDemandAdminCleanerMessageListener.class.getName(), new Date(System.currentTimeMillis() + (long)cleanUpInterval * 3600000L), null, cleanUpInterval, TimeUnit.HOUR);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)new SchedulerEntryImpl(OnDemandAdminCleanerMessageListener.class.getName(), trigger), "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        int cleanUpInterval = this._onDemandAdminConfiguration.cleanUpInterval();
        this._onDemandAdminManager.cleanUpOnDemandAdminUsers(new Date(System.currentTimeMillis() - 3600000L * (long)cleanUpInterval));
    }
}

