/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.vulcan.openapi.contributor;

import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.internal.vulcan.openapi.contributor.BaseOpenAPIContributor;
import com.liferay.object.rest.internal.vulcan.openapi.contributor.util.OpenAPIContributorUtil;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResource;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionMetadataRegistry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.resource.OpenAPIResource;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.UriInfo;
import org.osgi.framework.BundleContext;

public class ObjectEntryOpenAPIContributor
extends BaseOpenAPIContributor {
    private final BundleContext _bundleContext;
    private final ObjectActionLocalService _objectActionLocalService;
    private final ObjectDefinition _objectDefinition;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryOpenAPIResource _objectEntryOpenAPIResource;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;
    private final OpenAPIResource _openAPIResource;

    public ObjectEntryOpenAPIContributor(BundleContext bundleContext, DTOConverterRegistry dtoConverterRegistry, ObjectActionLocalService objectActionLocalService, ObjectDefinition objectDefinition, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryOpenAPIResource objectEntryOpenAPIResource, ObjectRelationshipLocalService objectRelationshipLocalService, OpenAPIResource openAPIResource, SystemObjectDefinitionMetadataRegistry systemObjectDefinitionMetadataRegistry) {
        this._bundleContext = bundleContext;
        this._objectActionLocalService = objectActionLocalService;
        this._objectDefinition = objectDefinition;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryOpenAPIResource = objectEntryOpenAPIResource;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._openAPIResource = openAPIResource;
        this.init(dtoConverterRegistry, systemObjectDefinitionMetadataRegistry);
    }

    public void contribute(OpenAPI openAPI, UriInfo uriInfo) throws Exception {
        List objectActions = this._objectActionLocalService.getObjectActions(this._objectDefinition.getObjectDefinitionId(), "standalone");
        Map<ObjectRelationship, ObjectDefinition> relatedObjectDefinitionsMap = this._getRelatedObjectDefinitionsMap();
        Paths paths = openAPI.getPaths();
        for (String key : new ArrayList(paths.keySet())) {
            if (!key.contains("objectActionName") && !key.contains("objectRelationshipName")) continue;
            if (key.contains("objectActionName")) {
                if (GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-166918"))) {
                    ListUtil.isNotEmptyForEach((List)objectActions, objectAction -> this._addObjectActionPathItem(key, (ObjectAction)objectAction, paths));
                }
            } else if (key.contains("objectRelationshipName")) {
                for (Map.Entry<ObjectRelationship, ObjectDefinition> entry : relatedObjectDefinitionsMap.entrySet()) {
                    final ObjectRelationship objectRelationship = entry.getKey();
                    ObjectDefinition relatedObjectDefinition = entry.getValue();
                    if (!relatedObjectDefinition.isSystem() || GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-162966"))) {
                        String relatedSchemaName = this.getSchemaName(relatedObjectDefinition);
                        if (uriInfo != null) {
                            this._addObjectRelationshipSchema(relatedObjectDefinition, openAPI, relatedSchemaName);
                        }
                        this._addObjectRelationshipPathItem(key, objectRelationship, paths, relatedSchemaName);
                    }
                    ((Schema)openAPI.getComponents().getSchemas().get(this._objectDefinition.getShortName())).getProperties().put(objectRelationship.getName(), new Schema<Object>(){
                        {
                            this.setDescription(StringBundler.concat((String[])new String[]{"Information about the relationship ", objectRelationship.getName(), " can be embedded with ", "\"nestedFields\"."}));
                        }
                    });
                }
            }
            paths.remove((Object)key);
        }
    }

    private void _addObjectActionPathItem(String key, ObjectAction objectAction, Paths paths) {
        paths.addPathItem(StringUtil.replace((String)key, (String[])new String[]{"objectEntry", "{objectActionName}"}, (String[])new String[]{StringUtil.lowerCaseFirstLetter((String)this._objectDefinition.getShortName()), objectAction.getName()}), this._createObjectActionPathItem(objectAction, (PathItem)paths.get((Object)key)));
    }

    private void _addObjectRelationshipPathItem(String key, ObjectRelationship objectRelationship, Paths paths, String schemaName) {
        paths.addPathItem(StringUtil.replace((String)key, (String[])new String[]{"currentObjectEntry", "{objectRelationshipName}", "relatedObjectEntry"}, (String[])new String[]{StringUtil.lowerCaseFirstLetter((String)this._objectDefinition.getShortName()), objectRelationship.getName(), StringUtil.lowerCaseFirstLetter((String)schemaName)}), this._createObjectRelationshipPathItem(objectRelationship, (PathItem)paths.get((Object)key), schemaName));
    }

    private void _addObjectRelationshipSchema(ObjectDefinition objectDefinition, OpenAPI openAPI, String schemaName) throws Exception {
        Components components = openAPI.getComponents();
        Map schemas = components.getSchemas();
        if (schemas.containsKey(schemaName)) {
            return;
        }
        OpenAPI sourceOpenAPI = objectDefinition.isSystem() ? OpenAPIContributorUtil.getSystemObjectOpenAPI(this._bundleContext, this.getExternalDTOClassName(objectDefinition), this._openAPIResource) : OpenAPIContributorUtil.getObjectEntryOpenAPI(objectDefinition, this._objectEntryOpenAPIResource);
        OpenAPIContributorUtil.copySchemas(schemaName, sourceOpenAPI, objectDefinition.isSystem(), openAPI);
    }

    private PathItem _createObjectActionPathItem(final ObjectAction objectAction, PathItem pathItem) {
        Map operations = pathItem.readOperationsMap();
        final Operation operation = (Operation)operations.get(PathItem.HttpMethod.PUT);
        if (operation == null) {
            return new PathItem();
        }
        return new PathItem(){
            {
                this.put(new Operation(){
                    {
                        this.operationId(StringBundler.concat((String[])new String[]{"put", ObjectEntryOpenAPIContributor.this._objectDefinition.getShortName(), StringUtil.upperCaseFirstLetter((String)objectAction.getName())}));
                        this.parameters(ObjectEntryOpenAPIContributor.this._getParameters(operation, null));
                        this.responses(operation.getResponses());
                        this.tags(operation.getTags());
                    }
                });
            }
        };
    }

    private PathItem _createObjectRelationshipPathItem(final ObjectRelationship objectRelationship, final PathItem pathItem, final String schemaName) {
        Map operations = pathItem.readOperationsMap();
        Operation operation = (Operation)operations.get(PathItem.HttpMethod.GET);
        if (operation != null) {
            return new PathItem(){
                {
                    this.get(ObjectEntryOpenAPIContributor.this._getObjectRelationshipGetOperation(objectRelationship, pathItem.getGet(), schemaName));
                }
            };
        }
        operation = (Operation)operations.get(PathItem.HttpMethod.PUT);
        if (operation != null) {
            return new PathItem(){
                {
                    this.put(ObjectEntryOpenAPIContributor.this._getObjectRelationshipPutOperation(objectRelationship, pathItem.getPut(), schemaName));
                }
            };
        }
        return new PathItem();
    }

    private Content _getContent(Content originalContent, String schemaName) {
        Content content = new Content();
        final Schema schema = new Schema();
        schema.set$ref(schemaName);
        for (String key : originalContent.keySet()) {
            content.addMediaType(key, new MediaType(){
                {
                    this.setSchema(schema);
                }
            });
        }
        return content;
    }

    private ApiResponses _getObjectRelationshipApiResponses(Operation operation, final String schemaName) {
        ApiResponses apiResponses = new ApiResponses();
        ApiResponses operationApiResponses = operation.getResponses();
        for (Map.Entry entry : operationApiResponses.entrySet()) {
            final ApiResponse apiResponse = (ApiResponse)entry.getValue();
            apiResponses.put(entry.getKey(), (Object)new ApiResponse(){
                {
                    this.setContent(ObjectEntryOpenAPIContributor.this._getContent(apiResponse.getContent(), schemaName));
                    this.setDescription(apiResponse.getDescription());
                }
            });
        }
        return apiResponses;
    }

    private Operation _getObjectRelationshipGetOperation(final ObjectRelationship objectRelationship, final Operation operation, final String schemaName) {
        return new Operation(){
            {
                this.operationId(StringBundler.concat((String[])new String[]{"get", ObjectEntryOpenAPIContributor.this._objectDefinition.getShortName(), StringUtil.upperCaseFirstLetter((String)objectRelationship.getName()), schemaName, "Page"}));
                this.parameters(ObjectEntryOpenAPIContributor.this._getParameters(operation, schemaName));
                this.responses(ObjectEntryOpenAPIContributor.this._getObjectRelationshipApiResponses(operation, OpenAPIContributorUtil.getPageSchemaName(schemaName)));
                this.tags(operation.getTags());
            }
        };
    }

    private Operation _getObjectRelationshipPutOperation(final ObjectRelationship objectRelationship, final Operation operation, final String schemaName) {
        return new Operation(){
            {
                this.operationId(StringBundler.concat((String[])new String[]{"put", ObjectEntryOpenAPIContributor.this._objectDefinition.getShortName(), StringUtil.upperCaseFirstLetter((String)objectRelationship.getName()), schemaName}));
                this.parameters(ObjectEntryOpenAPIContributor.this._getParameters(operation, schemaName));
                this.responses(ObjectEntryOpenAPIContributor.this._getObjectRelationshipApiResponses(operation, schemaName));
                this.tags(operation.getTags());
            }
        };
    }

    private List<Parameter> _getParameters(Operation operation, String schemaName) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (final Parameter parameter : operation.getParameters()) {
            String parameterName = parameter.getName();
            if (Objects.equals(parameterName, "objectActionName") || Objects.equals(parameterName, "objectRelationshipName")) continue;
            if (Objects.equals(parameterName, "currentObjectEntryId")) {
                parameterName = StringUtil.replace((String)parameterName, (String)"currentObjectEntry", (String)StringUtil.lowerCaseFirstLetter((String)this._objectDefinition.getShortName()));
            } else if (Objects.equals(parameterName, "relatedObjectEntryId")) {
                parameterName = StringUtil.replace((String)parameterName, (String)"relatedObjectEntry", (String)StringUtil.lowerCaseFirstLetter((String)schemaName));
            }
            final String finalParameterName = parameterName;
            parameters.add(new Parameter(){
                {
                    this.in(parameter.getIn());
                    this.name(finalParameterName);
                    this.required(parameter.getRequired());
                    this.schema(parameter.getSchema());
                }
            });
        }
        return parameters;
    }

    private Map<ObjectRelationship, ObjectDefinition> _getRelatedObjectDefinitionsMap() {
        HashMap<ObjectRelationship, ObjectDefinition> relatedObjectDefinitionsMap = new HashMap<ObjectRelationship, ObjectDefinition>();
        List objectRelationships = this._objectRelationshipLocalService.getObjectRelationships(this._objectDefinition.getObjectDefinitionId());
        for (ObjectRelationship objectRelationship : objectRelationships) {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectRelationship.getObjectDefinitionId2());
            relatedObjectDefinitionsMap.put(objectRelationship, objectDefinition);
        }
        return relatedObjectDefinitionsMap;
    }
}

