/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.petra.sql.dsl.expression;

import com.liferay.object.field.business.type.ObjectFieldBusinessTypeRegistry;
import com.liferay.object.rest.internal.odata.filter.expression.PredicateExpressionVisitorImpl;
import com.liferay.object.rest.odata.entity.v1_0.ObjectEntryEntityModel;
import com.liferay.object.rest.petra.sql.dsl.expression.FilterPredicateFactory;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FilterPredicateFactory.class})
public class FilterPredicateFactoryImpl
implements FilterPredicateFactory {
    private static final Log _log = LogFactoryUtil.getLog(FilterPredicateFactoryImpl.class);
    @Reference
    private FilterParserProvider _filterParserProvider;
    @Reference
    private ObjectFieldBusinessTypeRegistry _objectFieldBusinessTypeRegistry;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;

    public Predicate create(String filterString, long objectDefinitionId) {
        if (Validator.isNull((String)filterString)) {
            return null;
        }
        try {
            ObjectEntryEntityModel entityModel = new ObjectEntryEntityModel(this._objectFieldLocalService.getObjectFields(objectDefinitionId));
            FilterParser filterParser = this._filterParserProvider.provide((EntityModel)entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            Expression expression = oDataFilter.getExpression();
            return (Predicate)expression.accept((ExpressionVisitor)new PredicateExpressionVisitorImpl((EntityModel)entityModel, objectDefinitionId, this._objectFieldBusinessTypeRegistry, this._objectFieldLocalService));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return null;
        }
    }
}

