/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.openapi.v1_0;

import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.rest.dto.v1_0.FileEntry;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.rest.internal.resource.v1_0.ObjectEntryRelatedObjectsResourceImpl;
import com.liferay.object.rest.internal.resource.v1_0.ObjectEntryResourceImpl;
import com.liferay.object.rest.internal.resource.v1_0.OpenAPIResourceImpl;
import com.liferay.object.rest.internal.vulcan.openapi.contributor.ObjectEntryOpenAPIContributor;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResource;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionMetadataRegistry;
import com.liferay.portal.kernel.util.TreeMapBuilder;
import com.liferay.portal.vulcan.batch.engine.Field;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.openapi.DTOProperty;
import com.liferay.portal.vulcan.openapi.OpenAPISchemaFilter;
import com.liferay.portal.vulcan.openapi.contributor.OpenAPIContributor;
import com.liferay.portal.vulcan.resource.OpenAPIResource;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectEntryOpenAPIResource.class})
public class ObjectEntryOpenAPIResourceImpl
implements ObjectEntryOpenAPIResource {
    private BundleContext _bundleContext;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ObjectActionLocalService _objectActionLocalService;
    private ObjectDefinition _objectDefinition;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private OpenAPIResource _openAPIResource;
    @Reference
    private SystemObjectDefinitionMetadataRegistry _systemObjectDefinitionMetadataRegistry;

    public Map<String, Field> getFields(ObjectDefinition objectDefinition, UriInfo uriInfo) throws Exception {
        Response response = this.getOpenAPI(objectDefinition, "json", uriInfo);
        OpenAPI openAPI = (OpenAPI)response.getEntity();
        Components components = openAPI.getComponents();
        Map schemas = components.getSchemas();
        Schema schema = (Schema)schemas.get(this._objectDefinition.getShortName());
        if (schema == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        List<String> requiredPropertySchemaNames = this._getRequiredPropertySchemaNames(schema);
        Map properties = schema.getProperties();
        for (Map.Entry schemaEntry : properties.entrySet()) {
            String propertyName = (String)schemaEntry.getKey();
            Schema propertySchema = (Schema)schemaEntry.getValue();
            if (Optional.ofNullable(propertySchema.getReadOnly()).orElse(false).booleanValue() || Optional.ofNullable(propertySchema.getWriteOnly()).orElse(false).booleanValue() || propertyName.startsWith("x-")) continue;
            fields.put(propertyName, Field.of((String)propertySchema.getDescription(), (String)propertyName, (boolean)Optional.ofNullable(propertySchema.getReadOnly()).orElse(false), (boolean)requiredPropertySchemaNames.contains(propertyName), (String)propertySchema.getType(), (boolean)Optional.ofNullable(propertySchema.getWriteOnly()).orElse(false)));
        }
        return fields;
    }

    public Response getOpenAPI(ObjectDefinition objectDefinition, String type, UriInfo uriInfo) throws Exception {
        this._objectDefinition = objectDefinition;
        return this._openAPIResource.getOpenAPI((OpenAPIContributor)new ObjectEntryOpenAPIContributor(this._bundleContext, this._dtoConverterRegistry, this._objectActionLocalService, this._objectDefinition, this._objectDefinitionLocalService, this, this._objectRelationshipLocalService, this._openAPIResource, this._systemObjectDefinitionMetadataRegistry), this._getOpenAPISchemaFilter(this._objectDefinition.getRESTContextPath()), (Set)new HashSet<Class<?>>(){
            {
                this.add(ObjectEntryRelatedObjectsResourceImpl.class);
                this.add(ObjectEntryResourceImpl.class);
                this.add(OpenAPIResourceImpl.class);
            }
        }, type, uriInfo);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private DTOProperty _getDTOProperty(final ObjectField objectField) {
        if (Objects.equals(objectField.getBusinessType(), "Attachment")) {
            DTOProperty dtoProperty = new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), objectField.getName(), FileEntry.class.getSimpleName());
            dtoProperty.setDTOProperties(Arrays.asList(new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), "id", Long.class.getSimpleName()), new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), "name", String.class.getSimpleName())));
            dtoProperty.setRequired(objectField.isRequired());
            return dtoProperty;
        }
        if (objectField.getListTypeDefinitionId() != 0L) {
            DTOProperty dtoProperty = new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), objectField.getName(), ListEntry.class.getSimpleName());
            dtoProperty.setDTOProperties(Arrays.asList(new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), "key", String.class.getSimpleName()), new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), "name", String.class.getSimpleName())));
            dtoProperty.setRequired(objectField.isRequired());
            return dtoProperty;
        }
        return new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), objectField.getName(), objectField.getDBType()){
            {
                super(x0, x1, x2);
                this.setRequired(objectField.isRequired());
            }
        };
    }

    private OpenAPISchemaFilter _getOpenAPISchemaFilter(String applicationPath) {
        OpenAPISchemaFilter openAPISchemaFilter = new OpenAPISchemaFilter();
        openAPISchemaFilter.setApplicationPath(applicationPath);
        DTOProperty dtoProperty = new DTOProperty(new HashMap(), "ObjectEntry", "Object");
        ArrayList<DTOProperty> dtoProperties = new ArrayList<DTOProperty>();
        for (final ObjectField objectField : this._objectFieldLocalService.getObjectFields(this._objectDefinition.getObjectDefinitionId())) {
            dtoProperties.add(this._getDTOProperty(objectField));
            if (!Objects.equals(objectField.getRelationshipType(), "oneToMany")) continue;
            dtoProperties.add(new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), ObjectFieldSettingUtil.getValue((String)"objectRelationshipERCFieldName", (ObjectField)objectField), String.class.getSimpleName()){
                {
                    super(x0, x1, x2);
                    this.setRequired(objectField.isRequired());
                }
            });
        }
        dtoProperty.setDTOProperties(dtoProperties);
        DTOProperty pageDTOProperty = new DTOProperty(new HashMap(), "PageObject", "Object");
        pageDTOProperty.setDTOProperties(Arrays.asList(new DTOProperty(new HashMap(), "items", "Array"){
            {
                this.setDTOProperties(Arrays.asList(new DTOProperty(new HashMap(), "ObjectEntry", "Object")));
            }
        }));
        openAPISchemaFilter.setDTOProperties(Arrays.asList(dtoProperty, pageDTOProperty));
        openAPISchemaFilter.setSchemaMappings((Map)TreeMapBuilder.create(Collections.reverseOrder()).put((Object)"ObjectEntry", (Object)this._objectDefinition.getShortName()).put((Object)"PageObject", (Object)("Page" + this._objectDefinition.getShortName())).put((Object)"PageObjectEntry", (Object)("Page" + this._objectDefinition.getShortName())).build());
        return openAPISchemaFilter;
    }

    private List<String> _getRequiredPropertySchemaNames(Schema schema) {
        List<String> requiredPropertySchemaNames = schema.getRequired();
        if (requiredPropertySchemaNames == null) {
            requiredPropertySchemaNames = Collections.emptyList();
        }
        return requiredPropertySchemaNames;
    }
}

