/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.odata.entity.v1_0;

import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectField;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.BooleanEntityField;
import com.liferay.portal.odata.entity.CollectionEntityField;
import com.liferay.portal.odata.entity.DateEntityField;
import com.liferay.portal.odata.entity.DateTimeEntityField;
import com.liferay.portal.odata.entity.DoubleEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.entity.IdEntityField;
import com.liferay.portal.odata.entity.IntegerEntityField;
import com.liferay.portal.odata.entity.StringEntityField;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ObjectEntryEntityModel
implements EntityModel {
    private final Map<String, EntityField> _entityFieldsMap = HashMapBuilder.put((Object)"creator", (Object)new StringEntityField("creator", locale -> "creator")).put((Object)"creatorId", (Object)new IntegerEntityField("creatorId", locale -> "userId")).put((Object)"dateCreated", (Object)new DateTimeEntityField("dateCreated", locale -> "createDate", locale -> "createDate")).put((Object)"dateModified", (Object)new DateTimeEntityField("dateModified", locale -> "modifiedDate", locale -> "modifiedDate")).put((Object)"externalReferenceCode", () -> new StringEntityField("externalReferenceCode", locale -> "externalReferenceCode")).put((Object)"id", (Object)new IdEntityField("id", locale -> "id", String::valueOf)).put((Object)"objectDefinitionId", (Object)new IntegerEntityField("objectDefinitionId", locale -> "objectDefinitionId")).put((Object)"siteId", (Object)new IntegerEntityField("siteId", locale -> "groupId")).put((Object)"status", (Object)new CollectionEntityField((EntityField)new IntegerEntityField("status", locale -> "status"))).put((Object)"userId", (Object)new IntegerEntityField("userId", locale -> "userId")).build();

    public ObjectEntryEntityModel(List<ObjectField> objectFields) {
        for (ObjectField objectField : objectFields) {
            if (objectField.isSystem()) continue;
            if (!Objects.equals(objectField.getRelationshipType(), "oneToMany")) {
                EntityField entityField = this._getEntityField(objectField);
                if (entityField == null) continue;
                this._entityFieldsMap.putIfAbsent(objectField.getName(), entityField);
                continue;
            }
            String objectFieldName = objectField.getName();
            this._entityFieldsMap.put(objectFieldName, (EntityField)new IdEntityField(objectFieldName, locale -> objectFieldName, String::valueOf));
            String objectRelationshipERCFieldName = ObjectFieldSettingUtil.getValue((String)"objectRelationshipERCFieldName", (ObjectField)objectField);
            this._entityFieldsMap.put(objectRelationshipERCFieldName, (EntityField)new StringEntityField(objectRelationshipERCFieldName, locale -> objectFieldName));
            String relationshipIdName = objectFieldName.substring(objectFieldName.lastIndexOf("_") + 1);
            this._entityFieldsMap.put(relationshipIdName, (EntityField)new IdEntityField(relationshipIdName, locale -> objectFieldName, String::valueOf));
        }
    }

    public Map<String, EntityField> getEntityFieldsMap() {
        return this._entityFieldsMap;
    }

    private EntityField _getEntityField(ObjectField objectField) {
        if (objectField.compareBusinessType("Aggregation") || objectField.compareBusinessType("Formula")) {
            return null;
        }
        if (Objects.equals(objectField.getBusinessType(), "Attachment")) {
            return new StringEntityField(objectField.getName(), locale -> objectField.getName());
        }
        if (Objects.equals(objectField.getBusinessType(), "MultiselectPicklist")) {
            return new CollectionEntityField((EntityField)new StringEntityField(objectField.getName(), locale -> objectField.getName()));
        }
        if (Objects.equals(objectField.getDBType(), "BigDecimal") || Objects.equals(objectField.getDBType(), "Double")) {
            return new DoubleEntityField(objectField.getName(), locale -> objectField.getName());
        }
        if (Objects.equals(objectField.getDBType(), "Boolean")) {
            return new BooleanEntityField(objectField.getName(), locale -> objectField.getName());
        }
        if (Objects.equals(objectField.getDBType(), "Clob") || Objects.equals(objectField.getDBType(), "String")) {
            return new StringEntityField(objectField.getName(), locale -> objectField.getName());
        }
        if (Objects.equals(objectField.getDBType(), "Date")) {
            return new DateEntityField(objectField.getName(), locale -> objectField.getName(), locale -> objectField.getName());
        }
        if (Objects.equals(objectField.getDBType(), "Integer") || Objects.equals(objectField.getDBType(), "Long")) {
            return new IntegerEntityField(objectField.getName(), locale -> objectField.getName());
        }
        return null;
    }
}

