/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.manager.v1_0;

import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.field.util.ObjectFieldUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.util.GroupUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseObjectEntryManager {
    @Reference
    protected DDMExpressionFactory ddmExpressionFactory;
    @Reference
    protected DepotEntryLocalService depotEntryLocalService;
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected Language language;
    @Reference
    protected ObjectEntryLocalService objectEntryLocalService;
    @Reference
    protected ObjectFieldLocalService objectFieldLocalService;
    @Reference
    protected ObjectScopeProviderRegistry objectScopeProviderRegistry;
    @Reference
    protected PermissionCheckerFactory permissionCheckerFactory;

    protected Map<String, String> addDeleteAction(ObjectDefinition objectDefinition, String scopeKey, User user) {
        if (!this._hasPortletResourcePermission(objectDefinition, scopeKey, user, "DELETE")) {
            return null;
        }
        return Collections.emptyMap();
    }

    protected void checkPortletResourcePermission(String actionId, ObjectDefinition objectDefinition, String scopeKey, User user) throws Exception {
        PortletResourcePermission portletResourcePermission = this.getPortletResourcePermission(objectDefinition);
        portletResourcePermission.check(this.permissionCheckerFactory.create(user), this.getGroupId(objectDefinition, scopeKey), actionId);
    }

    protected long getGroupId(ObjectDefinition objectDefinition, String scopeKey) {
        ObjectScopeProvider objectScopeProvider = this.objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
        if (objectScopeProvider.isGroupAware()) {
            if (Objects.equals(objectDefinition.getScope(), "site")) {
                return GetterUtil.getLong((Object)GroupUtil.getGroupId((long)objectDefinition.getCompanyId(), (String)scopeKey, (GroupLocalService)this.groupLocalService));
            }
            return GetterUtil.getLong((Object)GroupUtil.getDepotGroupId((String)scopeKey, (long)objectDefinition.getCompanyId(), (DepotEntryLocalService)this.depotEntryLocalService, (GroupLocalService)this.groupLocalService));
        }
        return 0L;
    }

    protected PortletResourcePermission getPortletResourcePermission(ObjectDefinition objectDefinition) {
        ModelResourcePermission modelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)objectDefinition.getClassName());
        return modelResourcePermission.getPortletResourcePermission();
    }

    protected void validateReadOnlyObjectFields(String externalReferenceCode, ObjectDefinition objectDefinition, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) throws Exception {
        HashMap values = new HashMap();
        if (externalReferenceCode != null) {
            ObjectEntry serviceBuilderObjectEntry = this.objectEntryLocalService.fetchObjectEntry(externalReferenceCode, objectDefinition.getObjectDefinitionId());
            if (serviceBuilderObjectEntry == null) {
                return;
            }
            values.putAll(this.objectEntryLocalService.getSystemValues(serviceBuilderObjectEntry));
            values.putAll(this.objectEntryLocalService.getValues(serviceBuilderObjectEntry));
        }
        ObjectFieldUtil.validateReadOnlyObjectFields((DDMExpressionFactory)this.ddmExpressionFactory, values, (List)this.objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId()), objectEntry.getProperties());
    }

    private boolean _hasPortletResourcePermission(ObjectDefinition objectDefinition, String scopeKey, User user, String actionId) {
        PortletResourcePermission portletResourcePermission = this.getPortletResourcePermission(objectDefinition);
        return portletResourcePermission.contains(this.permissionCheckerFactory.create(user), this.getGroupId(objectDefinition, scopeKey), actionId);
    }
}

