/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.dto.v1_0.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.object.rest.dto.v1_0.Link;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.Portal;

public class LinkUtil {
    private static final Log _log = LogFactoryUtil.getLog(LinkUtil.class);

    public static Link toLink(final DLAppService dlAppService, final DLFileEntry dlFileEntry, final DLURLHelper dlURLHelper, final String objectDefinitionExternalReferenceCode, final String objectEntryExternalReferenceCode, final Portal portal) {
        return new Link(){
            {
                this.label = dlFileEntry.getFileName();
                this.setHref((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> {
                    try {
                        FileEntry fileEntry = dlAppService.getFileEntry(dlFileEntry.getFileEntryId());
                        String downloadURL = dlURLHelper.getDownloadURL(fileEntry, fileEntry.getFileVersion(), null, "");
                        downloadURL = HttpComponentsUtil.addParameter((String)downloadURL, (String)"objectDefinitionExternalReferenceCode", (String)objectDefinitionExternalReferenceCode);
                        downloadURL = HttpComponentsUtil.addParameter((String)downloadURL, (String)"objectEntryExternalReferenceCode", (String)objectEntryExternalReferenceCode);
                        return downloadURL;
                    }
                    catch (Exception exception) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Throwable)exception);
                        }
                        return StringBundler.concat((String[])new String[]{portal.getPathContext(), portal.getPathMain(), "/portal/login"});
                    }
                }));
            }
        };
    }
}

