Liferay.Loader.define('liferay!object-js-components-web$moment@2.29.4/dist/locale/ro', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        //! moment.js locale configuration
        //! locale : Romanian [ro]
        //! author : Vlad Gurdiga : https://github.com/gurdiga
        //! author : Valentin Agachi : https://github.com/avaly
        //! author : Emanuel Cepoi : https://github.com/cepem

        import moment from '../moment';

        function relativeTimeWithPlural(number, withoutSuffix, key) {
            var separator = ' ';
            if (number % 100 >= 20 || number >= 100 && number % 100 === 0) {
                separator = ' de ';
            }
            return number + separator + {
                ss: 'secunde',
                mm: 'minute',
                hh: 'ore',
                dd: 'zile',
                ww: 'săptămâni',
                MM: 'luni',
                yy: 'ani'
            }[key];
        }

        export default moment.defineLocale('ro', {
            months: 'ianuarie_februarie_martie_aprilie_mai_iunie_iulie_august_septembrie_octombrie_noiembrie_decembrie'.split('_'),
            monthsShort: 'ian._feb._mart._apr._mai_iun._iul._aug._sept._oct._nov._dec.'.split('_'),
            monthsParseExact: true,
            weekdays: 'duminică_luni_marți_miercuri_joi_vineri_sâmbătă'.split('_'),
            weekdaysShort: 'Dum_Lun_Mar_Mie_Joi_Vin_Sâm'.split('_'),
            weekdaysMin: 'Du_Lu_Ma_Mi_Jo_Vi_Sâ'.split('_'),
            longDateFormat: {
                LT: 'H:mm',
                LTS: 'H:mm:ss',
                L: 'DD.MM.YYYY',
                LL: 'D MMMM YYYY',
                LLL: 'D MMMM YYYY H:mm',
                LLLL: 'dddd, D MMMM YYYY H:mm'
            },
            calendar: {
                sameDay: '[azi la] LT',
                nextDay: '[mâine la] LT',
                nextWeek: 'dddd [la] LT',
                lastDay: '[ieri la] LT',
                lastWeek: '[fosta] dddd [la] LT',
                sameElse: 'L'
            },
            relativeTime: {
                future: 'peste %s',
                past: '%s în urmă',
                s: 'câteva secunde',
                ss: relativeTimeWithPlural,
                m: 'un minut',
                mm: relativeTimeWithPlural,
                h: 'o oră',
                hh: relativeTimeWithPlural,
                d: 'o zi',
                dd: relativeTimeWithPlural,
                w: 'o săptămână',
                ww: relativeTimeWithPlural,
                M: 'o lună',
                MM: relativeTimeWithPlural,
                y: 'un an',
                yy: relativeTimeWithPlural
            },
            week: {
                dow: 1, // Monday is the first day of the week.
                doy: 7 // The week that contains Jan 7th is the first week of the year.
            }
        });
    }
});
//# sourceMappingURL=ro.js.map