/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.dynamic.data.mapping.internal.data.provider;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderException;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.KeyValuePair;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"ddm.data.provider.instance.id=objects"}, service={DDMDataProvider.class})
public class ObjectsDataProvider
implements DDMDataProvider {
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;

    public DDMDataProviderResponse getData(DDMDataProviderRequest ddmDataProviderRequest) throws DDMDataProviderException {
        try {
            DDMDataProviderResponse.Builder builder = DDMDataProviderResponse.Builder.newBuilder();
            ArrayList<KeyValuePair> keyValuePairs = new ArrayList<KeyValuePair>();
            List objectDefinitions = this._objectDefinitionLocalService.getObjectDefinitions(ddmDataProviderRequest.getCompanyId(), true, false, 0);
            for (ObjectDefinition objectDefinition : objectDefinitions) {
                keyValuePairs.add(new KeyValuePair(String.valueOf(objectDefinition.getObjectDefinitionId()), objectDefinition.getLabel(ddmDataProviderRequest.getLocale())));
            }
            builder.withOutput("Default-Output", keyValuePairs);
            return builder.build();
        }
        catch (SystemException systemException) {
            throw new DDMDataProviderException((Throwable)systemException);
        }
    }

    public Class<?> getSettings() {
        throw new UnsupportedOperationException();
    }
}

