/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.petra.sql.dsl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;

public class DynamicObjectDefinitionTableUtil {
    private static final Log _log = LogFactoryUtil.getLog(DynamicObjectDefinitionTableUtil.class);
    private static final Map<String, String> _dataTypes = HashMapBuilder.put((Object)"BigDecimal", (Object)"DECIMAL(30, 16)").put((Object)"Blob", (Object)"BLOB").put((Object)"Boolean", (Object)"BOOLEAN").put((Object)"Clob", (Object)"TEXT").put((Object)"Date", (Object)"DATE").put((Object)"DateTime", (Object)"DATE").put((Object)"Double", (Object)"DOUBLE").put((Object)"Integer", (Object)"INTEGER").put((Object)"Long", (Object)"LONG").put((Object)"String", (Object)"VARCHAR(280)").build();
    private static final Map<String, Class<?>> _javaClasses = HashMapBuilder.put((Object)"BigDecimal", BigDecimal.class).put((Object)"Blob", Blob.class).put((Object)"Boolean", Boolean.class).put((Object)"Clob", String.class).put((Object)"Date", Date.class).put((Object)"DateTime", Timestamp.class).put((Object)"Double", Double.class).put((Object)"Integer", Integer.class).put((Object)"Long", Long.class).put((Object)"String", String.class).build();
    private static final Map<String, Integer> _sqlTypes = HashMapBuilder.put((Object)"BigDecimal", (Object)3).put((Object)"Blob", (Object)2004).put((Object)"Boolean", (Object)16).put((Object)"Clob", (Object)2005).put((Object)"Date", (Object)91).put((Object)"DateTime", (Object)93).put((Object)"Double", (Object)8).put((Object)"Integer", (Object)4).put((Object)"Long", (Object)-5).put((Object)"String", (Object)12).build();

    public static String getAlterTableAddColumnSQL(String tableName, String columnName, String dbType) {
        String sql = StringBundler.concat((String[])new String[]{"alter table ", tableName, " add ", columnName, " ", DynamicObjectDefinitionTableUtil.getDataType(dbType), DynamicObjectDefinitionTableUtil.getSQLColumnNull(dbType)});
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        return sql;
    }

    public static String getDataType(String dbType) {
        return _dataTypes.get(dbType);
    }

    public static Class<?> getJavaClass(String dbType) {
        return _javaClasses.get(dbType);
    }

    public static String getSQLColumnNull(String dbType) {
        if (dbType.equals("BigDecimal") || dbType.equals("Double") || dbType.equals("Integer") || dbType.equals("Long")) {
            return " default 0";
        }
        if (dbType.equals("Boolean")) {
            return " default FALSE";
        }
        if (dbType.equals("Date") || dbType.equals("DateTime")) {
            return " null";
        }
        return "";
    }

    public static Integer getSQLType(String dbType) {
        return _sqlTypes.get(dbType);
    }
}

