/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.field.util;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFieldAccessor;
import com.liferay.object.dynamic.data.mapping.expression.ObjectEntryDDMExpressionFieldAccessor;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.exception.ObjectFieldReadOnlyException;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.ObjectFieldLocalServiceUtil;
import com.liferay.object.service.ObjectFieldSettingLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ObjectFieldUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectFieldUtil.class);

    public static ObjectField addCustomObjectField(ObjectField objectField) throws Exception {
        return ObjectFieldLocalServiceUtil.addCustomObjectField(objectField.getExternalReferenceCode(), objectField.getUserId(), objectField.getListTypeDefinitionId(), objectField.getObjectDefinitionId(), objectField.getBusinessType(), objectField.getDBType(), objectField.isIndexed(), objectField.isIndexedAsKeyword(), objectField.getIndexedLanguageId(), objectField.getLabelMap(), objectField.isLocalized(), objectField.getName(), objectField.getReadOnly(), objectField.getReadOnlyConditionExpression(), objectField.isRequired(), objectField.isState(), objectField.getObjectFieldSettings());
    }

    public static ObjectField createObjectField(long listTypeDefinitionId, String businessType, String dbColumnName, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, String label, String name, boolean required, boolean system) {
        return ObjectFieldUtil.createObjectField(businessType, dbColumnName, dbType, indexed, indexedAsKeyword, indexedLanguageId, label, listTypeDefinitionId, name, Collections.emptyList(), "false", null, required, system);
    }

    public static ObjectField createObjectField(String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, String label, String name, boolean required) {
        return ObjectFieldUtil.createObjectField(0L, businessType, null, dbType, indexed, indexedAsKeyword, indexedLanguageId, label, name, required, false);
    }

    public static ObjectField createObjectField(String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, String label, String name, List<ObjectFieldSetting> objectFieldSettings, boolean required) {
        return ObjectFieldUtil.createObjectField(businessType, null, dbType, indexed, indexedAsKeyword, indexedLanguageId, label, 0L, name, objectFieldSettings, "false", null, required, false);
    }

    public static ObjectField createObjectField(String businessType, String dbType, String name) {
        return ObjectFieldUtil.createObjectField(businessType, dbType, name, name, false);
    }

    public static ObjectField createObjectField(String businessType, String dbColumnName, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, String label, long listTypeDefinitionId, String name, List<ObjectFieldSetting> objectFieldSettings, String readOnly, String readOnlyConditionExpression, boolean required, boolean system) {
        ObjectField objectField = ObjectFieldLocalServiceUtil.createObjectField(0L);
        objectField.setListTypeDefinitionId(listTypeDefinitionId);
        objectField.setBusinessType(businessType);
        objectField.setDBColumnName(dbColumnName);
        objectField.setDBType(dbType);
        objectField.setIndexed(indexed);
        objectField.setIndexedAsKeyword(indexedAsKeyword);
        objectField.setIndexedLanguageId(indexedLanguageId);
        objectField.setLabelMap(LocalizedMapUtil.getLocalizedMap((String)label));
        objectField.setName(name);
        objectField.setObjectFieldSettings(objectFieldSettings);
        objectField.setReadOnly(readOnly);
        objectField.setReadOnlyConditionExpression(readOnlyConditionExpression);
        objectField.setRequired(required);
        objectField.setSystem(system);
        return objectField;
    }

    public static ObjectField createObjectField(String businessType, String dbType, String name, List<ObjectFieldSetting> objectFieldSettings) {
        return ObjectFieldUtil.createObjectField(businessType, null, dbType, false, false, null, name, 0L, name, objectFieldSettings, "false", null, false, false);
    }

    public static ObjectField createObjectField(String businessType, String dbType, String label, String name) {
        return ObjectFieldUtil.createObjectField(businessType, dbType, label, name, false);
    }

    public static ObjectField createObjectField(String businessType, String dbType, String label, String name, boolean required) {
        return ObjectFieldUtil.createObjectField(0L, businessType, null, dbType, false, false, null, label, name, required, false);
    }

    public static ObjectField createObjectField(String businessType, String dbType, String label, String name, List<ObjectFieldSetting> objectFieldSettings) {
        return ObjectFieldUtil.createObjectField(businessType, null, dbType, false, false, null, label, 0L, name, objectFieldSettings, "false", null, false, false);
    }

    public static String getDateTimePattern(String value) {
        if (value.length() == 10) {
            return "yyyy-MM-dd";
        }
        if (value.length() == 16) {
            return "yyyy-MM-dd HH:mm";
        }
        if (value.length() == 20) {
            return "yyyy-MM-dd'T'HH:mm:ss'Z'";
        }
        if (value.length() == 21) {
            return "yyyy-MM-dd HH:mm:ss.S";
        }
        if (value.length() == 23 && value.charAt(10) == 'T') {
            return "yyyy-MM-dd'T'HH:mm:ss.SSS";
        }
        if (value.length() == 24 && value.charAt(10) == 'T') {
            return "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        }
        if (value.length() == 28 && value.charAt(23) == '+') {
            return "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
        }
        return "yyyy-MM-dd'T'HH:mm:ssZ";
    }

    public static Map<String, ObjectField> toObjectFieldsMap(List<ObjectField> objectFields) {
        LinkedHashMap<String, ObjectField> objectFieldsMap = new LinkedHashMap<String, ObjectField>();
        for (ObjectField objectField : objectFields) {
            objectFieldsMap.put(objectField.getName(), objectField);
        }
        return objectFieldsMap;
    }

    public static void validateReadOnlyObjectFields(DDMExpressionFactory ddmExpressionFactory, Map<String, Object> existingValues, List<ObjectField> objectFields, Map<String, Object> values) throws PortalException {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-170122") || ObjectEntryThreadLocal.isSkipReadOnlyObjectFieldsValidation()) {
            return;
        }
        existingValues.put("currentUserId", PrincipalThreadLocal.getUserId());
        Map<String, ObjectField> objectFieldsMap = ObjectFieldUtil.toObjectFieldsMap(objectFields);
        for (ObjectField objectField : objectFields) {
            if (existingValues.get(objectField.getName()) == null) {
                existingValues.put(objectField.getName(), ObjectFieldSettingUtil.getDefaultValueAsString(null, objectField.getObjectFieldId(), ObjectFieldSettingLocalServiceUtil.getService(), null));
            }
            if (objectField.isLocalized()) {
                objectFieldsMap.put(objectField.getI18nObjectFieldName(), objectField);
                continue;
            }
            if (!Objects.equals(objectField.getRelationshipType(), "oneToMany")) continue;
            String objectRelationshipERCObjectFieldName = ObjectFieldSettingUtil.getValue("objectRelationshipERCObjectFieldName", objectField);
            objectFieldsMap.put(objectRelationshipERCObjectFieldName, objectField);
        }
        for (Map.Entry entry : values.entrySet()) {
            ObjectField objectField;
            if (Objects.equals(entry.getKey(), "status") || (objectField = objectFieldsMap.get(entry.getKey())) == null || Objects.equals(objectField.getReadOnly(), "false")) continue;
            if (Objects.equals(objectField.getReadOnly(), "true")) {
                ObjectFieldUtil._validateNewValue(existingValues.get(entry.getKey()), objectField, entry.getValue());
                continue;
            }
            try {
                DDMExpression ddmExpression = ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)objectField.getReadOnlyConditionExpression()).withDDMExpressionFieldAccessor((DDMExpressionFieldAccessor)new ObjectEntryDDMExpressionFieldAccessor(existingValues)).build());
                ddmExpression.setVariables(existingValues);
                if (!((Boolean)ddmExpression.evaluate()).booleanValue()) continue;
                ObjectFieldUtil._validateNewValue(existingValues.get(entry.getKey()), objectField, entry.getValue());
            }
            catch (DDMExpressionException ddmExpressionException) {
                _log.error((Throwable)ddmExpressionException);
            }
        }
    }

    private static void _validateNewValue(Object existingValue, ObjectField objectField, Object value) throws PortalException {
        block15: {
            if (Validator.isNull((Object)existingValue) && Validator.isNull((Object)value)) {
                return;
            }
            if (Objects.equals(objectField.getDBType(), "BigDecimal") || Objects.equals(objectField.getDBType(), "Double") || Objects.equals(objectField.getDBType(), "Integer") || Objects.equals(objectField.getDBType(), "Long")) {
                BigDecimal bigDecimal2;
                BigDecimal bigDecimal1 = new BigDecimal(existingValue.toString());
                if (bigDecimal1.compareTo(bigDecimal2 = new BigDecimal(value.toString())) == 0) {
                    return;
                }
            } else if (Objects.equals(objectField.getDBType(), "Blob") || Objects.equals(objectField.getDBType(), "Clob") || Objects.equals(objectField.getDBType(), "String")) {
                if (Objects.equals(GetterUtil.getString((Object)value), GetterUtil.getString((Object)existingValue))) {
                    return;
                }
            } else if (Objects.equals(objectField.getDBType(), "Boolean")) {
                if (Objects.equals(GetterUtil.getBoolean((Object)value), GetterUtil.getBoolean((Object)existingValue))) {
                    return;
                }
            } else {
                if (Objects.equals(objectField.getDBType(), "Date") || Objects.equals(objectField.getDBType(), "DateTime")) {
                    Timestamp timestamp = (Timestamp)existingValue;
                    Date existingValueDate = new Date(timestamp.getTime());
                    SimpleDateFormat dateFormat = new SimpleDateFormat(ObjectFieldUtil.getDateTimePattern((String)value));
                    try {
                        Date valueDate = dateFormat.parse((String)value);
                        if (DateUtil.equals((Date)existingValueDate, (Date)valueDate)) {
                            return;
                        }
                        break block15;
                    }
                    catch (ParseException parseException) {
                        throw new RuntimeException(parseException);
                    }
                }
                if (Objects.equals(existingValue, value)) {
                    return;
                }
            }
        }
        throw new ObjectFieldReadOnlyException("Object field " + objectField.getName() + " is read only");
    }
}

