/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.field.business.type;

import com.liferay.object.exception.ObjectFieldSettingNameException;
import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public interface ObjectFieldBusinessType {
    default public Set<String> getAllowedObjectFieldSettingsNames() {
        return Collections.emptySet();
    }

    public String getDBType();

    public String getDDMFormFieldTypeName();

    default public String getDDMFormFieldTypeName(boolean localized) {
        return this.getDDMFormFieldTypeName();
    }

    default public String getDescription(Locale locale) {
        return "";
    }

    default public Object getDisplayContextValue(ObjectField objectField, long userId, Map<String, Object> values) throws PortalException {
        if (objectField.isLocalized()) {
            return values.get(objectField.getI18nObjectFieldName());
        }
        return this.getValue(objectField, userId, values);
    }

    public String getLabel(Locale var1);

    public String getName();

    default public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        return Collections.emptyMap();
    }

    public PropertyDefinition.PropertyType getPropertyType();

    default public Set<String> getRequiredObjectFieldSettingsNames(ObjectField objectField) {
        return Collections.emptySet();
    }

    default public Set<String> getUnmodifiableObjectFieldSettingsNames() {
        return Collections.emptySet();
    }

    default public Object getValue(ObjectField objectField, long userId, Map<String, Object> values) throws PortalException {
        String localizedValue;
        if (!objectField.isLocalized()) {
            return values.get(objectField.getName());
        }
        Map localizedValues = (Map)values.get(objectField.getI18nObjectFieldName());
        if (localizedValues == null) {
            return values.get(objectField.getName());
        }
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        if (locale == null) {
            locale = LocaleThreadLocal.getSiteDefaultLocale();
        }
        if (locale == null) {
            User user = GuestOrUserUtil.getGuestOrUser();
            locale = user.getLocale();
        }
        if ((localizedValue = (String)localizedValues.get(LocaleUtil.toLanguageId((Locale)locale))) != null) {
            return localizedValue;
        }
        return "";
    }

    default public boolean isVisible(ObjectDefinition objectDefinition) {
        return true;
    }

    default public void predefineObjectFieldSettings(ObjectField newObjectField, ObjectField oldObjectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
    }

    default public void validateObjectFieldSettings(ObjectField objectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        HashSet<String> missingRequiredObjectFieldSettingsNames = new HashSet<String>();
        HashMap<String, String> objectFieldSettingsValuesMap = new HashMap<String, String>();
        for (ObjectFieldSetting objectFieldSetting : objectFieldSettings) {
            objectFieldSettingsValuesMap.put(objectFieldSetting.getName(), objectFieldSetting.getValue());
        }
        for (String requiredObjectFieldSettingName : this.getRequiredObjectFieldSettingsNames(objectField)) {
            if (!Validator.isNull((String)((String)objectFieldSettingsValuesMap.get(requiredObjectFieldSettingName)))) continue;
            missingRequiredObjectFieldSettingsNames.add(requiredObjectFieldSettingName);
        }
        if (!missingRequiredObjectFieldSettingsNames.isEmpty()) {
            throw new ObjectFieldSettingValueException.MissingRequiredValues(objectField.getName(), missingRequiredObjectFieldSettingsNames);
        }
        HashSet<String> notAllowedObjectFieldSettingsNames = new HashSet<String>(objectFieldSettingsValuesMap.keySet());
        notAllowedObjectFieldSettingsNames.removeAll(this.getAllowedObjectFieldSettingsNames());
        notAllowedObjectFieldSettingsNames.removeAll(this.getRequiredObjectFieldSettingsNames(objectField));
        if (!notAllowedObjectFieldSettingsNames.isEmpty()) {
            throw new ObjectFieldSettingNameException.NotAllowedNames(objectField.getName(), notAllowedObjectFieldSettingsNames);
        }
        this.validateObjectFieldSettingsDefaultValue(objectField, objectFieldSettingsValuesMap);
    }

    default public void validateObjectFieldSettingsDefaultValue(ObjectField objectField, Map<String, String> objectFieldSettingsValuesMap) throws PortalException {
        String defaultValueType = objectFieldSettingsValuesMap.get("defaultValueType");
        if (defaultValueType == null) {
            return;
        }
        if (!StringUtil.equals((String)defaultValueType, (String)"expressionBuilder") && !StringUtil.equals((String)defaultValueType, (String)"inputAsValue")) {
            throw new ObjectFieldSettingValueException.InvalidValue(objectField.getName(), "defaultValueType", defaultValueType);
        }
    }
}

