/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.exception;

import com.liferay.object.model.ObjectState;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class ObjectEntryValuesException
extends PortalException {
    private List<Object> _arguments;
    private String _messageKey;

    public List<Object> getArguments() {
        return this._arguments;
    }

    public String getMessageKey() {
        return this._messageKey;
    }

    private ObjectEntryValuesException(List<Object> arguments, String message, String messageKey) {
        super(message);
        this._arguments = arguments;
        this._messageKey = messageKey;
    }

    private ObjectEntryValuesException(List<Object> arguments, String message, String messageKey, Throwable throwable) {
        super(message, throwable);
        this._arguments = arguments;
        this._messageKey = messageKey;
    }

    private ObjectEntryValuesException(String message) {
        super(message);
    }

    public static class UnmodifiableAccountEntryObjectField
    extends ObjectEntryValuesException {
        public UnmodifiableAccountEntryObjectField(String objectFieldName) {
            super(StringBundler.concat((String[])new String[]{"The object field ", objectFieldName, " is unmodifiable because it is the account entry ", "restrictor"}));
        }
    }

    public static class UniqueValueConstraintViolation
    extends ObjectEntryValuesException {
        public UniqueValueConstraintViolation(String columnName, Serializable columnValue, String objectFieldLabel, String tableName, Throwable throwable) {
            super(Arrays.asList(objectFieldLabel), String.format("Unique value constraint violation for %s.%s with value %s", tableName, columnName, columnValue), "the-x-is-already-in-use-please-enter-a-unique-x", throwable);
        }
    }

    public static class Required
    extends ObjectEntryValuesException {
        private String _objectFieldName;

        public Required(String objectFieldName) {
            super(String.format("No value was provided for required object field \"%s\"", objectFieldName));
            this._objectFieldName = objectFieldName;
        }

        public String getObjectFieldName() {
            return this._objectFieldName;
        }
    }

    public static class OneToOneConstraintViolation
    extends ObjectEntryValuesException {
        public OneToOneConstraintViolation(String columnName, long columnValue, String tableName) {
            super(String.format("One to one constraint violation for %s.%s with value %s", tableName, columnName, columnValue));
        }
    }

    public static class MustNotBeDuplicate
    extends ObjectEntryValuesException {
        public MustNotBeDuplicate(String value) {
            super("Duplicate value " + value);
        }
    }

    public static class ListTypeEntry
    extends ObjectEntryValuesException {
        private final String _objectFieldName;

        public ListTypeEntry(String objectFieldName) {
            super(String.format("Object field name \"%s\" is not mapped to a valid list type entry", objectFieldName));
            this._objectFieldName = objectFieldName;
        }

        public String getObjectFieldName() {
            return this._objectFieldName;
        }
    }

    public static class InvalidObjectStateTransition
    extends ObjectEntryValuesException {
        private final ObjectState _sourceObjectState;
        private final ObjectState _targetObjectState;

        public InvalidObjectStateTransition(String sourceObjectName, ObjectState sourceObjectState, String targetObjectName, ObjectState targetObjectState) {
            super((List)Arrays.asList(sourceObjectName, targetObjectName), String.format("Object state ID %d cannot be transitioned to object state ID %d", sourceObjectState.getObjectStateId(), targetObjectState.getObjectStateId()), "object-state-x-cannot-be-transitioned-to-object-state-x");
            this._sourceObjectState = sourceObjectState;
            this._targetObjectState = targetObjectState;
        }

        public ObjectState getSourceObjectState() {
            return this._sourceObjectState;
        }

        public ObjectState getTargetObjectState() {
            return this._targetObjectState;
        }
    }

    public static class InvalidObjectField
    extends ObjectEntryValuesException {
        public InvalidObjectField(String message, String messageKey, List<Object> arguments) {
            super((List)arguments, message, messageKey);
        }
    }

    public static class InvalidFileExtension
    extends ObjectEntryValuesException {
        private final String _fileExtension;
        private final String _objectFieldName;

        public InvalidFileExtension(String fileExtension, String objectFieldName) {
            super(String.format("The file extension %s is invalid for object field \"%s\"", fileExtension, objectFieldName));
            this._fileExtension = fileExtension;
            this._objectFieldName = objectFieldName;
        }

        public String getFileExtension() {
            return this._fileExtension;
        }

        public String getObjectFieldName() {
            return this._objectFieldName;
        }
    }

    public static class ExceedsTextMaxLength
    extends ObjectEntryValuesException {
        private final int _maxLength;
        private final String _objectFieldName;

        public ExceedsTextMaxLength(int maxLength, String objectFieldName) {
            super(String.format("Object entry value exceeds the maximum length of %s characters for object field \"%s\"", maxLength, objectFieldName));
            this._maxLength = maxLength;
            this._objectFieldName = objectFieldName;
        }

        public int getMaxLength() {
            return this._maxLength;
        }

        public String getObjectFieldName() {
            return this._objectFieldName;
        }
    }

    public static class ExceedsMaxFileSize
    extends ObjectEntryValuesException {
        private final long _maxFileSize;
        private final String _objectFieldName;

        public ExceedsMaxFileSize(long maxFileSize, String objectFieldName) {
            super(String.format("File exceeds the maximum permitted size of %s MB for object field \"%s\"", maxFileSize, objectFieldName));
            this._maxFileSize = maxFileSize;
            this._objectFieldName = objectFieldName;
        }

        public long getMaxFileSize() {
            return this._maxFileSize;
        }

        public String getObjectFieldName() {
            return this._objectFieldName;
        }
    }

    public static class ExceedsLongSize
    extends ObjectEntryValuesException {
        private final int _maxLength;
        private final String _objectFieldName;

        public ExceedsLongSize(int maxLength, String objectFieldName) {
            super("Object entry value exceeds long field allowed size");
            this._maxLength = maxLength;
            this._objectFieldName = objectFieldName;
        }

        public int getMaxLength() {
            return this._maxLength;
        }

        public String getObjectFieldName() {
            return this._objectFieldName;
        }
    }

    public static class ExceedsLongMinSize
    extends ObjectEntryValuesException {
        private final long _minValue;
        private final String _objectFieldName;

        public ExceedsLongMinSize(long minValue, String objectFieldName) {
            super("Object entry value falls below minimum long field allowed size");
            this._minValue = minValue;
            this._objectFieldName = objectFieldName;
        }

        public long getMinValue() {
            return this._minValue;
        }

        public String getObjectFieldName() {
            return this._objectFieldName;
        }
    }

    public static class ExceedsLongMaxSize
    extends ObjectEntryValuesException {
        private final long _maxValue;
        private final String _objectFieldName;

        public ExceedsLongMaxSize(long maxValue, String objectFieldName) {
            super("Object entry value exceeds maximum long field allowed size");
            this._maxValue = maxValue;
            this._objectFieldName = objectFieldName;
        }

        public long getMaxValue() {
            return this._maxValue;
        }

        public String getObjectFieldName() {
            return this._objectFieldName;
        }
    }

    public static class ExceedsIntegerSize
    extends ObjectEntryValuesException {
        private final int _maxLength;
        private final String _objectFieldName;

        public ExceedsIntegerSize(int maxLength, String objectFieldName) {
            super("Object entry value exceeds integer field allowed size");
            this._maxLength = maxLength;
            this._objectFieldName = objectFieldName;
        }

        public int getMaxLength() {
            return this._maxLength;
        }

        public String getObjectFieldName() {
            return this._objectFieldName;
        }
    }
}

