/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.entry.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.object.model.ObjectField;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlParserUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;

public class ObjectEntryValuesUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryValuesUtil.class);

    public static Object getTitleFieldValue(String businessType, Map<String, Object> modelAttributes, ObjectField objectField, User user, Map<String, Object> values) {
        String objectFieldName = objectField.getName();
        if (!values.containsKey(objectFieldName)) {
            return modelAttributes.get(objectField.getDBColumnName());
        }
        Object value = values.get(objectFieldName);
        if (StringUtil.equals((String)businessType, (String)"Boolean")) {
            return GetterUtil.getBoolean((Object)value);
        }
        if (!(value instanceof Map)) {
            return value;
        }
        Map localizedValues = (Map)value;
        String siteDefaultLanguageId = LanguageUtil.getLanguageId((Locale)LocaleUtil.getSiteDefault());
        if (localizedValues.containsKey(siteDefaultLanguageId)) {
            return localizedValues.get(siteDefaultLanguageId);
        }
        if (user != null && localizedValues.containsKey(user.getLanguageId())) {
            return localizedValues.get(user.getLanguageId());
        }
        return localizedValues.get(LanguageUtil.getLanguageId((Locale)LocaleUtil.getDefault()));
    }

    public static String getValueString(ObjectField objectField, Map<String, Serializable> values) {
        Serializable value = values.get(objectField.getName());
        if (StringUtil.equals((String)objectField.getBusinessType(), (String)"Attachment")) {
            return ObjectEntryValuesUtil._getFileName(GetterUtil.getLong((Object)value));
        }
        if (StringUtil.equals((String)objectField.getBusinessType(), (String)"RichText")) {
            return HtmlParserUtil.extractText((String)GetterUtil.getString((Object)value));
        }
        if (Validator.isNull((Object)value)) {
            String objectFieldName = objectField.getName();
            if (objectFieldName.equals("creator")) {
                objectFieldName = "userName";
            } else if (objectFieldName.equals("id")) {
                objectFieldName = "objectEntryId";
            }
            value = values.get(objectFieldName);
        }
        return String.valueOf(value);
    }

    private static String _getFileName(long dlFileEntryId) {
        try {
            DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.getDLFileEntry((long)dlFileEntryId);
            return dlFileEntry.getFileName();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return "";
        }
    }
}

