/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.entry.util;

import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.InternalServerErrorException;

public class ObjectEntryDTOConverterUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryDTOConverterUtil.class);

    public static DTOConverter<BaseModel<?>, ?> getDTOConverter(DTOConverterRegistry dtoConverterRegistry, SystemObjectDefinitionManager systemObjectDefinitionManager) throws Exception {
        JaxRsApplicationDescriptor jaxRsApplicationDescriptor = systemObjectDefinitionManager.getJaxRsApplicationDescriptor();
        DTOConverter dtoConverter = dtoConverterRegistry.getDTOConverter(jaxRsApplicationDescriptor.getApplicationName(), systemObjectDefinitionManager.getModelClassName(), jaxRsApplicationDescriptor.getVersion());
        if (dtoConverter == null) {
            throw new InternalServerErrorException("No DTO converter found for " + systemObjectDefinitionManager.getModelClassName());
        }
        return dtoConverter;
    }

    public static Object toDTO(BaseModel<?> baseModel, DTOConverterRegistry dtoConverterRegistry, SystemObjectDefinitionManager systemObjectDefinitionManager, User user) throws Exception {
        DTOConverter<BaseModel<?>, ?> dtoConverter = ObjectEntryDTOConverterUtil.getDTOConverter(dtoConverterRegistry, systemObjectDefinitionManager);
        Locale locale = null;
        if (user != null) {
            locale = user.getLocale();
        }
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(false, Collections.emptyMap(), dtoConverterRegistry, (Object)baseModel.getPrimaryKeyObj(), locale, null, user);
        return dtoConverter.toDTO((DTOConverterContext)defaultDTOConverterContext);
    }

    public static Map<String, Object> toValues(BaseModel<?> baseModel, DTOConverterRegistry dtoConverterRegistry, String objectDefinitionName, SystemObjectDefinitionManagerRegistry systemObjectDefinitionManagerRegistry, User user) {
        try {
            Object dto = ObjectEntryDTOConverterUtil.toDTO(baseModel, dtoConverterRegistry, systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinitionName), user);
            if (dto == null) {
                return Collections.emptyMap();
            }
            return (Map)ObjectMapperUtil.readValue(Map.class, (String)dto.toString());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return Collections.emptyMap();
        }
    }
}

