/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.object.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.LocalizedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the ObjectValidationRule service. Represents a row in the &quot;ObjectValidationRule&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.object.model.impl.ObjectValidationRuleModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.object.model.impl.ObjectValidationRuleImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectValidationRule
 * @generated
 */
@ProviderType
public interface ObjectValidationRuleModel
	extends BaseModel<ObjectValidationRule>, LocalizedModel, MVCCModel,
			ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a object validation rule model instance should use the {@link ObjectValidationRule} interface instead.
	 */

	/**
	 * Returns the primary key of this object validation rule.
	 *
	 * @return the primary key of this object validation rule
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this object validation rule.
	 *
	 * @param primaryKey the primary key of this object validation rule
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this object validation rule.
	 *
	 * @return the mvcc version of this object validation rule
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this object validation rule.
	 *
	 * @param mvccVersion the mvcc version of this object validation rule
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this object validation rule.
	 *
	 * @return the uuid of this object validation rule
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this object validation rule.
	 *
	 * @param uuid the uuid of this object validation rule
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the object validation rule ID of this object validation rule.
	 *
	 * @return the object validation rule ID of this object validation rule
	 */
	public long getObjectValidationRuleId();

	/**
	 * Sets the object validation rule ID of this object validation rule.
	 *
	 * @param objectValidationRuleId the object validation rule ID of this object validation rule
	 */
	public void setObjectValidationRuleId(long objectValidationRuleId);

	/**
	 * Returns the company ID of this object validation rule.
	 *
	 * @return the company ID of this object validation rule
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this object validation rule.
	 *
	 * @param companyId the company ID of this object validation rule
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this object validation rule.
	 *
	 * @return the user ID of this object validation rule
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this object validation rule.
	 *
	 * @param userId the user ID of this object validation rule
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this object validation rule.
	 *
	 * @return the user uuid of this object validation rule
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this object validation rule.
	 *
	 * @param userUuid the user uuid of this object validation rule
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this object validation rule.
	 *
	 * @return the user name of this object validation rule
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this object validation rule.
	 *
	 * @param userName the user name of this object validation rule
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this object validation rule.
	 *
	 * @return the create date of this object validation rule
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this object validation rule.
	 *
	 * @param createDate the create date of this object validation rule
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this object validation rule.
	 *
	 * @return the modified date of this object validation rule
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this object validation rule.
	 *
	 * @param modifiedDate the modified date of this object validation rule
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the object definition ID of this object validation rule.
	 *
	 * @return the object definition ID of this object validation rule
	 */
	public long getObjectDefinitionId();

	/**
	 * Sets the object definition ID of this object validation rule.
	 *
	 * @param objectDefinitionId the object definition ID of this object validation rule
	 */
	public void setObjectDefinitionId(long objectDefinitionId);

	/**
	 * Returns the active of this object validation rule.
	 *
	 * @return the active of this object validation rule
	 */
	public boolean getActive();

	/**
	 * Returns <code>true</code> if this object validation rule is active.
	 *
	 * @return <code>true</code> if this object validation rule is active; <code>false</code> otherwise
	 */
	public boolean isActive();

	/**
	 * Sets whether this object validation rule is active.
	 *
	 * @param active the active of this object validation rule
	 */
	public void setActive(boolean active);

	/**
	 * Returns the engine of this object validation rule.
	 *
	 * @return the engine of this object validation rule
	 */
	@AutoEscape
	public String getEngine();

	/**
	 * Sets the engine of this object validation rule.
	 *
	 * @param engine the engine of this object validation rule
	 */
	public void setEngine(String engine);

	/**
	 * Returns the error label of this object validation rule.
	 *
	 * @return the error label of this object validation rule
	 */
	public String getErrorLabel();

	/**
	 * Returns the localized error label of this object validation rule in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized error label of this object validation rule
	 */
	@AutoEscape
	public String getErrorLabel(Locale locale);

	/**
	 * Returns the localized error label of this object validation rule in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized error label of this object validation rule. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getErrorLabel(Locale locale, boolean useDefault);

	/**
	 * Returns the localized error label of this object validation rule in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized error label of this object validation rule
	 */
	@AutoEscape
	public String getErrorLabel(String languageId);

	/**
	 * Returns the localized error label of this object validation rule in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized error label of this object validation rule
	 */
	@AutoEscape
	public String getErrorLabel(String languageId, boolean useDefault);

	@AutoEscape
	public String getErrorLabelCurrentLanguageId();

	@AutoEscape
	public String getErrorLabelCurrentValue();

	/**
	 * Returns a map of the locales and localized error labels of this object validation rule.
	 *
	 * @return the locales and localized error labels of this object validation rule
	 */
	public Map<Locale, String> getErrorLabelMap();

	/**
	 * Sets the error label of this object validation rule.
	 *
	 * @param errorLabel the error label of this object validation rule
	 */
	public void setErrorLabel(String errorLabel);

	/**
	 * Sets the localized error label of this object validation rule in the language.
	 *
	 * @param errorLabel the localized error label of this object validation rule
	 * @param locale the locale of the language
	 */
	public void setErrorLabel(String errorLabel, Locale locale);

	/**
	 * Sets the localized error label of this object validation rule in the language, and sets the default locale.
	 *
	 * @param errorLabel the localized error label of this object validation rule
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setErrorLabel(
		String errorLabel, Locale locale, Locale defaultLocale);

	public void setErrorLabelCurrentLanguageId(String languageId);

	/**
	 * Sets the localized error labels of this object validation rule from the map of locales and localized error labels.
	 *
	 * @param errorLabelMap the locales and localized error labels of this object validation rule
	 */
	public void setErrorLabelMap(Map<Locale, String> errorLabelMap);

	/**
	 * Sets the localized error labels of this object validation rule from the map of locales and localized error labels, and sets the default locale.
	 *
	 * @param errorLabelMap the locales and localized error labels of this object validation rule
	 * @param defaultLocale the default locale
	 */
	public void setErrorLabelMap(
		Map<Locale, String> errorLabelMap, Locale defaultLocale);

	/**
	 * Returns the name of this object validation rule.
	 *
	 * @return the name of this object validation rule
	 */
	public String getName();

	/**
	 * Returns the localized name of this object validation rule in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized name of this object validation rule
	 */
	@AutoEscape
	public String getName(Locale locale);

	/**
	 * Returns the localized name of this object validation rule in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this object validation rule. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getName(Locale locale, boolean useDefault);

	/**
	 * Returns the localized name of this object validation rule in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized name of this object validation rule
	 */
	@AutoEscape
	public String getName(String languageId);

	/**
	 * Returns the localized name of this object validation rule in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this object validation rule
	 */
	@AutoEscape
	public String getName(String languageId, boolean useDefault);

	@AutoEscape
	public String getNameCurrentLanguageId();

	@AutoEscape
	public String getNameCurrentValue();

	/**
	 * Returns a map of the locales and localized names of this object validation rule.
	 *
	 * @return the locales and localized names of this object validation rule
	 */
	public Map<Locale, String> getNameMap();

	/**
	 * Sets the name of this object validation rule.
	 *
	 * @param name the name of this object validation rule
	 */
	public void setName(String name);

	/**
	 * Sets the localized name of this object validation rule in the language.
	 *
	 * @param name the localized name of this object validation rule
	 * @param locale the locale of the language
	 */
	public void setName(String name, Locale locale);

	/**
	 * Sets the localized name of this object validation rule in the language, and sets the default locale.
	 *
	 * @param name the localized name of this object validation rule
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setName(String name, Locale locale, Locale defaultLocale);

	public void setNameCurrentLanguageId(String languageId);

	/**
	 * Sets the localized names of this object validation rule from the map of locales and localized names.
	 *
	 * @param nameMap the locales and localized names of this object validation rule
	 */
	public void setNameMap(Map<Locale, String> nameMap);

	/**
	 * Sets the localized names of this object validation rule from the map of locales and localized names, and sets the default locale.
	 *
	 * @param nameMap the locales and localized names of this object validation rule
	 * @param defaultLocale the default locale
	 */
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale);

	/**
	 * Returns the script of this object validation rule.
	 *
	 * @return the script of this object validation rule
	 */
	@AutoEscape
	public String getScript();

	/**
	 * Sets the script of this object validation rule.
	 *
	 * @param script the script of this object validation rule
	 */
	public void setScript(String script);

	@Override
	public String[] getAvailableLanguageIds();

	@Override
	public String getDefaultLanguageId();

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException;

	@Override
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException;

	@Override
	public ObjectValidationRule cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}