/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.object.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.LocalizedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the ObjectLayoutBox service. Represents a row in the &quot;ObjectLayoutBox&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.object.model.impl.ObjectLayoutBoxModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.object.model.impl.ObjectLayoutBoxImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectLayoutBox
 * @generated
 */
@ProviderType
public interface ObjectLayoutBoxModel
	extends BaseModel<ObjectLayoutBox>, LocalizedModel, MVCCModel, ShardedModel,
			StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a object layout box model instance should use the {@link ObjectLayoutBox} interface instead.
	 */

	/**
	 * Returns the primary key of this object layout box.
	 *
	 * @return the primary key of this object layout box
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this object layout box.
	 *
	 * @param primaryKey the primary key of this object layout box
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this object layout box.
	 *
	 * @return the mvcc version of this object layout box
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this object layout box.
	 *
	 * @param mvccVersion the mvcc version of this object layout box
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this object layout box.
	 *
	 * @return the uuid of this object layout box
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this object layout box.
	 *
	 * @param uuid the uuid of this object layout box
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the object layout box ID of this object layout box.
	 *
	 * @return the object layout box ID of this object layout box
	 */
	public long getObjectLayoutBoxId();

	/**
	 * Sets the object layout box ID of this object layout box.
	 *
	 * @param objectLayoutBoxId the object layout box ID of this object layout box
	 */
	public void setObjectLayoutBoxId(long objectLayoutBoxId);

	/**
	 * Returns the company ID of this object layout box.
	 *
	 * @return the company ID of this object layout box
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this object layout box.
	 *
	 * @param companyId the company ID of this object layout box
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this object layout box.
	 *
	 * @return the user ID of this object layout box
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this object layout box.
	 *
	 * @param userId the user ID of this object layout box
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this object layout box.
	 *
	 * @return the user uuid of this object layout box
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this object layout box.
	 *
	 * @param userUuid the user uuid of this object layout box
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this object layout box.
	 *
	 * @return the user name of this object layout box
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this object layout box.
	 *
	 * @param userName the user name of this object layout box
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this object layout box.
	 *
	 * @return the create date of this object layout box
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this object layout box.
	 *
	 * @param createDate the create date of this object layout box
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this object layout box.
	 *
	 * @return the modified date of this object layout box
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this object layout box.
	 *
	 * @param modifiedDate the modified date of this object layout box
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the object layout tab ID of this object layout box.
	 *
	 * @return the object layout tab ID of this object layout box
	 */
	public long getObjectLayoutTabId();

	/**
	 * Sets the object layout tab ID of this object layout box.
	 *
	 * @param objectLayoutTabId the object layout tab ID of this object layout box
	 */
	public void setObjectLayoutTabId(long objectLayoutTabId);

	/**
	 * Returns the collapsable of this object layout box.
	 *
	 * @return the collapsable of this object layout box
	 */
	public boolean getCollapsable();

	/**
	 * Returns <code>true</code> if this object layout box is collapsable.
	 *
	 * @return <code>true</code> if this object layout box is collapsable; <code>false</code> otherwise
	 */
	public boolean isCollapsable();

	/**
	 * Sets whether this object layout box is collapsable.
	 *
	 * @param collapsable the collapsable of this object layout box
	 */
	public void setCollapsable(boolean collapsable);

	/**
	 * Returns the name of this object layout box.
	 *
	 * @return the name of this object layout box
	 */
	public String getName();

	/**
	 * Returns the localized name of this object layout box in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized name of this object layout box
	 */
	@AutoEscape
	public String getName(Locale locale);

	/**
	 * Returns the localized name of this object layout box in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this object layout box. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getName(Locale locale, boolean useDefault);

	/**
	 * Returns the localized name of this object layout box in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized name of this object layout box
	 */
	@AutoEscape
	public String getName(String languageId);

	/**
	 * Returns the localized name of this object layout box in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this object layout box
	 */
	@AutoEscape
	public String getName(String languageId, boolean useDefault);

	@AutoEscape
	public String getNameCurrentLanguageId();

	@AutoEscape
	public String getNameCurrentValue();

	/**
	 * Returns a map of the locales and localized names of this object layout box.
	 *
	 * @return the locales and localized names of this object layout box
	 */
	public Map<Locale, String> getNameMap();

	/**
	 * Sets the name of this object layout box.
	 *
	 * @param name the name of this object layout box
	 */
	public void setName(String name);

	/**
	 * Sets the localized name of this object layout box in the language.
	 *
	 * @param name the localized name of this object layout box
	 * @param locale the locale of the language
	 */
	public void setName(String name, Locale locale);

	/**
	 * Sets the localized name of this object layout box in the language, and sets the default locale.
	 *
	 * @param name the localized name of this object layout box
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setName(String name, Locale locale, Locale defaultLocale);

	public void setNameCurrentLanguageId(String languageId);

	/**
	 * Sets the localized names of this object layout box from the map of locales and localized names.
	 *
	 * @param nameMap the locales and localized names of this object layout box
	 */
	public void setNameMap(Map<Locale, String> nameMap);

	/**
	 * Sets the localized names of this object layout box from the map of locales and localized names, and sets the default locale.
	 *
	 * @param nameMap the locales and localized names of this object layout box
	 * @param defaultLocale the default locale
	 */
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale);

	/**
	 * Returns the priority of this object layout box.
	 *
	 * @return the priority of this object layout box
	 */
	public int getPriority();

	/**
	 * Sets the priority of this object layout box.
	 *
	 * @param priority the priority of this object layout box
	 */
	public void setPriority(int priority);

	/**
	 * Returns the type of this object layout box.
	 *
	 * @return the type of this object layout box
	 */
	@AutoEscape
	public String getType();

	/**
	 * Sets the type of this object layout box.
	 *
	 * @param type the type of this object layout box
	 */
	public void setType(String type);

	@Override
	public String[] getAvailableLanguageIds();

	@Override
	public String getDefaultLanguageId();

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException;

	@Override
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException;

	@Override
	public ObjectLayoutBox cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}