/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.relationship.util;

import com.liferay.object.exception.NoSuchObjectRelationshipException;
import com.liferay.object.exception.ObjectRelationshipReverseException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;
import java.util.Map;

public class ObjectRelationshipUtil {
    public static String getNotificationTermNamePrefix(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship) {
        return StringUtil.toUpperCase((String)StringBundler.concat((String[])new String[]{objectRelationship.getName(), "_", objectDefinition.getShortName()}));
    }

    public static ObjectRelationship getObjectRelationship(List<ObjectRelationship> objectRelationships) throws PortalException {
        if (ListUtil.isEmpty(objectRelationships)) {
            throw new NoSuchObjectRelationshipException();
        }
        if (objectRelationships.size() == 1) {
            return objectRelationships.get(0);
        }
        for (ObjectRelationship objectRelationship : objectRelationships) {
            if (objectRelationship.isReverse()) continue;
            return objectRelationship;
        }
        throw new ObjectRelationshipReverseException();
    }

    public static Map<String, String> getPKObjectFieldDBColumnNames(ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, boolean reverse) {
        String pkObjectFieldDBColumnName1 = objectDefinition1.getPKObjectFieldDBColumnName();
        String pkObjectFieldDBColumnName2 = objectDefinition2.getPKObjectFieldDBColumnName();
        if (objectDefinition1.getObjectDefinitionId() != objectDefinition2.getObjectDefinitionId()) {
            return HashMapBuilder.put((Object)"pkObjectFieldDBColumnName1", (Object)pkObjectFieldDBColumnName1).put((Object)"pkObjectFieldDBColumnName2", (Object)pkObjectFieldDBColumnName2).build();
        }
        return HashMapBuilder.put((Object)"pkObjectFieldDBColumnName1", (Object)pkObjectFieldDBColumnName1.concat(reverse ? "2" : "1")).put((Object)"pkObjectFieldDBColumnName2", (Object)pkObjectFieldDBColumnName2.concat(reverse ? "1" : "2")).build();
    }
}

