/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.field.filter.parser;

import com.liferay.frontend.data.set.filter.FDSFilter;
import com.liferay.frontend.data.set.filter.SelectionFDSFilterItem;
import com.liferay.object.exception.ObjectViewFilterColumnException;
import com.liferay.object.field.filter.parser.BaseObjectFieldFilterStrategy;
import com.liferay.object.field.frontend.data.set.filter.OneToManySelectionFDSFilter;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.model.ObjectViewFilterColumn;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class OneToManyObjectFieldFilterStrategy
extends BaseObjectFieldFilterStrategy {
    private final ObjectDefinition _objectDefinition1;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectField _objectField;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;
    private final PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    private final SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;

    public OneToManyObjectFieldFilterStrategy(Locale locale, ObjectDefinition objectDefinition1, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectField objectField, ObjectFieldLocalService objectFieldLocalService, ObjectRelationshipLocalService objectRelationshipLocalService, ObjectViewFilterColumn objectViewFilterColumn, PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry, SystemObjectDefinitionManagerRegistry systemObjectDefinitionManagerRegistry) {
        super(locale, objectViewFilterColumn);
        this._objectDefinition1 = objectDefinition1;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectField = objectField;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._persistedModelLocalServiceRegistry = persistedModelLocalServiceRegistry;
        this._systemObjectDefinitionManagerRegistry = systemObjectDefinitionManagerRegistry;
    }

    @Override
    public FDSFilter getFDSFilter() throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(this._objectField.getObjectFieldId());
        ObjectDefinition objectDefinition1 = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        ObjectField titleObjectField = null;
        titleObjectField = Validator.isNull((Long)objectDefinition1.getTitleObjectFieldId()) ? this._objectFieldLocalService.getObjectField(objectDefinition1.getObjectDefinitionId(), "id") : this._objectFieldLocalService.getObjectField(objectDefinition1.getTitleObjectFieldId());
        String restContextPath = null;
        if (objectDefinition1.isUnmodifiableSystemObject()) {
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition1.getName());
            JaxRsApplicationDescriptor jaxRsApplicationDescriptor = systemObjectDefinitionManager.getJaxRsApplicationDescriptor();
            restContextPath = "/o/" + jaxRsApplicationDescriptor.getRESTContextPath();
        } else {
            restContextPath = "/o" + objectDefinition1.getRESTContextPath();
        }
        return new OneToManySelectionFDSFilter(this.parse(), restContextPath, titleObjectField.getLabel(this.locale), this._objectField.getName(), titleObjectField.getName());
    }

    @Override
    public List<SelectionFDSFilterItem> getSelectionFDSFilterItems() throws PortalException {
        ArrayList<SelectionFDSFilterItem> selectionFDSFilterItems = new ArrayList<SelectionFDSFilterItem>();
        JSONArray jsonArray = this.getJSONArray();
        if (this._objectDefinition1.isUnmodifiableSystemObject()) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                selectionFDSFilterItems.add(new SelectionFDSFilterItem(this._objectEntryLocalService.getTitleValue(this._objectDefinition1.getObjectDefinitionId(), GetterUtil.getLong((Object)jsonArray.get(i))), (Object)jsonArray.getLong(i)));
            }
            return selectionFDSFilterItems;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            ObjectEntry objectEntry = this._objectEntryLocalService.fetchObjectEntry((String)jsonArray.get(i), this._objectDefinition1.getObjectDefinitionId());
            if (objectEntry == null) continue;
            selectionFDSFilterItems.add(new SelectionFDSFilterItem(objectEntry.getTitleValue(), (Object)objectEntry.getObjectEntryId()));
        }
        return selectionFDSFilterItems;
    }

    @Override
    public String toValueSummary() throws PortalException {
        return StringUtil.merge((Collection)ListUtil.toList(this.getSelectionFDSFilterItems(), selectionFDSFilterItem -> selectionFDSFilterItem.getLabel()), (String)", ");
    }

    @Override
    public void validate() throws PortalException {
        super.validate();
        JSONArray jsonArray = this.getJSONArray();
        if (this._objectDefinition1.isUnmodifiableSystemObject()) {
            PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(this._objectDefinition1.getClassName());
            for (int i = 0; i < jsonArray.length(); ++i) {
                try {
                    persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(GetterUtil.getLong((Object)jsonArray.get(i))));
                    continue;
                }
                catch (NoSuchModelException noSuchModelException) {
                    throw new ObjectViewFilterColumnException(noSuchModelException.getMessage());
                }
            }
        } else {
            for (int i = 0; i < jsonArray.length(); ++i) {
                if (!Validator.isNull((Object)this._objectEntryLocalService.fetchObjectEntry((String)jsonArray.get(i), this._objectDefinition1.getObjectDefinitionId()))) continue;
                throw new ObjectViewFilterColumnException(StringBundler.concat((String[])new String[]{"No ", this._objectDefinition1.getShortName(), " exists with the external reference code ", (String)jsonArray.get(i)}));
            }
        }
    }
}

